<?php

class CE_View_Helper_PriceAdaptiveSize extends Zend_View_Helper_Abstract
{
    public function priceAdaptiveSize($package, $user, $options = array())
    {
        $termId = $package['pricing'][$package['selectedTermIndex']]['termId'];
        $term = $package['pricing'][$package['selectedTermIndex']]['term'];

        if ($termId != 0) {
            $term = 'Every ' . $term;
        }

        $billingGateway = new BillingGateway($user);
        $term = $billingGateway->translateText($term, $user);
        $priceFormatted = $package['pricing'][$package['selectedTermIndex']]['price'];
        $priceClass = $this->priceClass($priceFormatted);

        $additional = '';

        if ($package['pricing'][$package['selectedTermIndex']]['termId'] != '0' && $options['monthlyPriceBreakdown']) {
            if ($options['showDiscountedPricingInBillingCycleSelector'] && $package['pricing'][$package['selectedTermIndex']]['signup_price_monthly'] !== false && $package['pricing'][$package['selectedTermIndex']]['signup_price_monthly'] !== $package['pricing'][$package['selectedTermIndex']]['price_monthly']) {
                $priceFormatted = $package['pricing'][$package['selectedTermIndex']]['signup_price_monthly'] . '/mo';
                $additional = '<del>' . $package['pricing'][$package['selectedTermIndex']]['price_monthly'] . '/mo</del>';
                $additionalClass = $this->priceClass($additional);
                $additional = "<span class='$additionalClass'>$additional</span>";
            } else {
                $priceFormatted = $package['pricing'][$package['selectedTermIndex']]['price_monthly'] . '/mo';
            }
        } else {
            if ($options['showDiscountedPricingInBillingCycleSelector'] && $package['pricing'][$package['selectedTermIndex']]['signup_price'] !==  false && $package['pricing'][$package['selectedTermIndex']]['signup_price'] !== $package['pricing'][$package['selectedTermIndex']]['price']) {
                $priceFormatted = $package['pricing'][$package['selectedTermIndex']]['signup_price'];
                $additional = '<del>' . $package['pricing'][$package['selectedTermIndex']]['price'] . '</del>';
                $additionalClass = $this->priceClass($additional);
                $additional = "<span class='$additionalClass'>$additional</span>";
            } else {
                $priceFormatted = $package['pricing'][$package['selectedTermIndex']]['price'];
                $additional = '<span>&nbsp;</span>';
            }
        }

        $setupfee = '';
        if (!$options['hideSetupFees'] && $package['pricing'][$package['selectedTermIndex']]['termId'] != '0') {
            $additional2 = $user->lang('Setup Fee') . ': ' . $package['pricing'][$package['selectedTermIndex']]['setup'];
            $setupfee = "<span class='compare-term setupfee'>$additional2</span>";
        }

        return <<<EOD

            $additional<div class='$priceClass'>$priceFormatted</div> <div class='compare-term'>$term</div> $setupfee
EOD;
    }

    public function priceClass($price)
    {
        $priceClass = '';
        $priceTextSize = strlen($price);

        if ($priceTextSize >= 10 && $priceTextSize < 12) {
            $priceClass = 'pricesMedium';
        } elseif ($priceTextSize >= 12 && $priceTextSize < 14) {
            $priceClass = 'pricesSmall';
        } elseif ($priceTextSize >= 14 && $priceTextSize < 16) {
            $priceClass = 'pricesXSmall';
        } elseif ($priceTextSize >= 16) {
            $priceClass = 'pricesXXSmall';
        }

        return $priceClass;
    }
}
