# OrderLineItemDiscount

### Description

Represents a discount that applies to one or more line items in an order.  Fixed-amount, order-scoped discounts are distributed across all non-zero line item totals. The amount distributed to each line item is relative to the amount contributed by the item to the order subtotal.

## Properties
Name | Getter | Setter | Type | Description | Notes
------------ | ------------- | ------------- | ------------- | ------------- | -------------
**uid** | getUid() | setUid($value) | **string** | Unique ID that identifies the discount only within this order. | [optional] [beta]
**catalog_object_id** | getCatalogObjectId() | setCatalogObjectId($value) | **string** | The catalog object id referencing &#x60;CatalogDiscount&#x60;. | [optional] 
**name** | getName() | setName($value) | **string** | The discount&#39;s name. | [optional] 
**type** | getType() | setType($value) | **string** | The type of the discount.  Discounts that don&#39;t reference a catalog object ID must have a type of &#x60;FIXED_PERCENTAGE&#x60; or &#x60;FIXED_AMOUNT&#x60;. See [OrderLineItemDiscountType](#type-orderlineitemdiscounttype) for possible values | [optional] 
**percentage** | getPercentage() | setPercentage($value) | **string** | The percentage of the discount, as a string representation of a decimal number. A value of &#x60;7.25&#x60; corresponds to a percentage of 7.25%.  &#x60;percentage&#x60; is not set for amount-based discounts. | [optional] 
**amount_money** | getAmountMoney() | setAmountMoney($value) | [**\SquareConnect\Model\Money**](Money.md) | The total declared monetary amount of the discount.  &#x60;amount_money&#x60; is not set for percentage-based discounts. | [optional] 
**applied_money** | getAppliedMoney() | setAppliedMoney($value) | [**\SquareConnect\Model\Money**](Money.md) | The amount of discount actually applied to the line item.  Represents the amount of money applied as a line item-scoped discount. When an amount-based discount is scoped to the entire order, the value of &#x60;applied_money&#x60; is different from &#x60;amount_money&#x60; because the total amount of the discount is distributed across all line items. | [optional] 
**metadata** | getMetadata() | setMetadata($value) | **map[string,string]** | Application-defined data attached to this discount. Metadata fields are intended to store descriptive references or associations with an entity in another system or store brief information about the object. Square does not process this field; it only stores and returns it in relevant API calls. Do not use metadata to store any sensitive information (personally identifiable information, card details, etc.).  Keys written by applications must be 60 characters or less and must be in the character set &#x60;[a-zA-Z0-9_-]&#x60;. Entries may also include metadata generated by Square. These keys are prefixed with a namespace, separated from the key with a &#39;:&#39; character.  Values have a max length of 255 characters.  An application may have up to 10 entries per metadata field.  Entries written by applications are private and can only be read or modified by the same application.  See [Metadata](https://developer.squareup.com/docs/build-basics/metadata) for more information. | [optional] [beta]
**scope** | getScope() | setScope($value) | **string** | Indicates the level at which the discount applies. For &#x60;ORDER&#x60; scoped discounts, Square generates references in &#x60;applied_discounts&#x60; on all order line items that do not have them. For &#x60;LINE_ITEM&#x60; scoped discounts, the discount only applies to line items with a discount reference in their &#x60;applied_discounts&#x60; field.  This field is immutable. To change the scope of a discount you must delete the discount and re-add it as a new discount. See [OrderLineItemDiscountScope](#type-orderlineitemdiscountscope) for possible values | [optional] 
**reward_ids** | getRewardIds() | setRewardIds($value) | **string[]** | The reward identifiers corresponding to this discount. The application and specification of discounts that have &#x60;reward_ids&#x60; are completely controlled by the backing criteria corresponding to the reward tiers of the rewards that are added to the order through the Loyalty API. To manually unapply discounts that are the result of added rewards, the rewards must be removed from the order through the Loyalty API. | [optional] [beta]

Note: All properties are protected and only accessed via getters and setters.

[[Back to Model list]](../../README.md#documentation-for-models) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to README]](../../README.md)

