<?php
use Illuminate\Database\Capsule\Manager as Capsule;

/**
 * Client Languages Report
 *
 * @category Report
 * @package  ClientExec
 * @author   Juan D. Bolivar <juan@clientexec.com>
 * @license  ClientExec License
 * @version  1.0
 * @link     http://www.clientexec.com
 *
 *************************************************
 *   1.0 Initial Report Released.  - Juan D. Bolivar
 ************************************************
 */

/**
 * Client_Languages Report Class
 *
 * @category Report
 * @package  ClientExec
 * @author   Juan D. Bolivar <juan@clientexec.com>
 * @license  ClientExec License
 * @version  1.0
 * @link     http://www.clientexec.com
 */
class Client_Languages extends Report
{
    private $lang;

    protected $featureSet = 'accounts';

    function __construct($user = null, $customer = null)
    {
        $this->lang = lang('Client Languages');
        parent::__construct($user, $customer);
    }

    /**
     * Report Process Method
     *
     * @return null - direct output
     */
    function process()
    {
        $this->SetDescription($this->user->lang('Displays total users using each language.'));

        $graphdata = @$_GET['graphdata'];
        $totalElements = 0;

        //SQL to generate the the result set of the report
        $result = Capsule::table('user_customuserfields as ucuf')
            ->select('ucuf.value')
            ->selectRaw('COUNT(ucuf.value) AS total')
            ->where('ucuf.customid', function ($subQuery) {
                $subQuery->select('cuf.id')
                    ->from('customuserfields as cuf')
                    ->where('cuf.name', 'Language')
                    ->limit(1);
            })
            ->groupBy('ucuf.value')
            ->orderByRaw('COUNT(ucuf.value) DESC')
            ->get();

        foreach ($result as $row) {
            $aGroup[] = array($this->user->lang($row->value), $row->total);
            $totalElements += $row->total;
        }

        if (isset($aGroup)) {
            $this->reportData[] = array(
                "group"     => $aGroup,
                "groupname" => $this->user->lang('Client Languages'),
                "label"     => array($this->user->lang('Language'),$this->user->lang('Clients')),
                "groupId"   => "",
                "isHidden"  => false
            );

            unset($aGroup);
        }
    }

}
?>