<?php
use Illuminate\Database\Capsule\Manager as Capsule;

/**
 * Top Clients Report
 *
 * @category Report
 * @package  ClientExec
 * @author   Juan D. Bolivar <juan@clientexec.com>
 * @license  ClientExec License
 * @version  1.0
 * @link     http://www.clientexec.com
 *
 *************************************************
 *   1.0 Initial Report Released.  - Juan D. Bolivar
 ************************************************
 */

require_once 'modules/admin/models/Package.php';
require_once 'modules/clients/models/UserPackage.php';
require_once 'modules/billing/models/Currency.php';
require_once 'modules/clients/models/User.php';
require_once 'modules/billing/models/Invoice.php';

/**
 * Top_Clients Report Class
 *
 * @category Report
 * @package  ClientExec
 * @author   Juan D. Bolivar <juan@clientexec.com>
 * @license  ClientExec License
 * @version  1.0
 * @link     http://www.clientexec.com
 */
class Top_Clients extends Report
{
    private $lang;

    protected $featureSet = 'billing';

    function __construct($user = null, $customer = null)
    {
        $this->lang = lang('Top Clients');
        parent::__construct($user,$customer);
    }

    /**
     * Report Process Method
     *
     * @return null - direct output
     */
    function process()
    {
        include_once 'modules/admin/models/StatusAliasGateway.php' ;

        // Set the report information
        $this->SetDescription($this->user->lang('Displays the Top Clients.'));

        @set_time_limit(0);

        // Load the top X information
        $topX = ((isset($_REQUEST['topX']))? $_REQUEST['topX'] : 10);

        // Load the currency information
        $currency = new Currency($this->user);

        $currencyCode = ((isset($_REQUEST['currencycode']))? $_REQUEST['currencycode'] : $this->settings->get('Default Currency'));
        $currencyName = $currency->getName($currencyCode);

        $filter = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'
            .'        '.$this->user->lang('Currency').': '
            .'        <select name="currencycode" id="currencycode" value="'.CE_Lib::viewEscape($currencyCode).'" > ';

        $isSelectedCurrencyInTheList = false;

        //Get all currencies of all invoices
        $result = Capsule::table('invoice as i')
            ->join('currency as c', 'c.abrv', '=', 'i.currency')
            ->select('c.abrv', 'c.name')
            ->distinct()
            ->orderBy('c.name', 'ASC')
            ->get();

        foreach ($result as $row) {
            if (!$isSelectedCurrencyInTheList && $currencyName < $row->name) {
                $filter .= '<option value="'.$currencyCode.'" selected>'.$currencyName.'</option>';
                $isSelectedCurrencyInTheList = true;
            } elseif ($currencyCode == $row->abrv) {
                $isSelectedCurrencyInTheList = true;
            }

            $filter .= '<option value="'.$row->abrv.'" '.(($currencyCode == $row->abrv)? 'selected' : '').'>'.$row->name.'</option>';
        }

        if (!$isSelectedCurrencyInTheList) {
            $filter .= '<option value="'.$currencyCode.'" selected>'.$currencyName.'</option>';
            $isSelectedCurrencyInTheList = true;
        }

        $filter .= '</select>';

        $toDisplay =
             '<form id="report" method="GET">'
            .'    <div style="text-align:center">'
            .'        Top: '
            .'        <input type="text" name="topX" id="topX" size="4" value="'.CE_Lib::viewEscape($topX).'" onkeydown="if (event.keyCode == 13) { event.preventDefault(); }"> '
            .$filter
            .'        <input type=button name=search class="btn" value=\''.$this->user->lang('Display').'\' onclick="ChangeTable(document.getElementById(\'topX\').value, document.getElementById(\'currencycode\').value);">'
            .'    </div>'
            .'</form>'
            .'</br>'
            .'<script type="text/javascript">'
            .'    function ChangeTable(topX, currencycode){'
            .'        location.href="index.php?fuse=reports&view=viewreport&controller=index&report=Top+Clients&type=Accounts&topX="+topX+"&currencycode="+currencycode;'
            .'    }'
            .'</script>';
        echo $toDisplay;

        $aGroup = array();
        $currency = new Currency($this->user);
        $total = array(
            'Packages'        => 0,
            'Active Packages' => 0,
            'Revenue'         => 0
        );

        $result = Capsule::table('invoice')
            ->select('customerid')
            ->selectRaw('SUM(amount - balance_due) AS totalRevenue')
            ->where('currency', $currencyCode)
            ->groupBy('customerid')
            ->orderBy('totalRevenue', 'DESC')
            ->limit($topX)
            ->get();

        foreach ($result as $row) {
            $user = new User($row->customerid);
            $CustomerLink = "<a href=\"index.php?fuse=clients&controller=userprofile&frmClientID=" . $row->customerid . "&view=credithistoryview\" target=blank>" . CE_Lib::viewEscape($user->getFullName()) . "</a>";
            $packages = $user->getTotalProducts();
            $activePackages = $user->getTotalActiveProducts();
            $aGroup[] = array($CustomerLink, $user->getDateActivated(), $packages.' ('.$activePackages.')', $currency->format($currencyCode, $row->totalRevenue, true, 'NONE', true));
            $total['Packages'] += (int)$packages;
            $total['Active Packages'] += (int)$activePackages;
            $total['Revenue'] += (float)$row->totalRevenue;
        }

        $aGroup[] = array('<b>'.$this->user->lang('Total').'</b>', '<b>'.'-'.'</b>', '<b>'.$total['Packages'].' ('.$total['Active Packages'].')'.'</b>', '<b>'.$currency->format($currencyCode, $total['Revenue'], true, 'NONE', true).'</b>');

        $labels = array(
            $this->user->lang('Client'),
            $this->user->lang('Registered'),
            $this->user->lang('Packages').' ('.$this->user->lang('Active').')',
            $this->user->lang('Total Revenue')
        );

        $this->reportData[] = array(
            "group"     => $aGroup,
            "groupname" => $this->user->lang('Top %s Clients', $topX).' ('.$currencyCode.')',
            "label"     => $labels,
            "groupId"   => "",
            "isHidden"  => false
        );
    }
}
?>
