<?php
use Illuminate\Database\Capsule\Manager as Capsule;

/**
 * Revenue by Product Report
 *
 * @category Report
 * @package  ClientExec
 * @author   Juan D. Bolivar <juan@clientexec.com>
 * @license  ClientExec License
 * @version  1.0
 * @link     http://www.clientexec.com
 *
 *************************************************
 *   1.0 Initial Report Released
 ************************************************
 */

require_once 'modules/billing/models/Currency.php';
require_once 'modules/billing/models/BillingType.php';
require_once('modules/clients/models/DomainNameGateway.php');
require_once 'modules/billing/models/BillingCycle.php';

/**
 * Revenue_By_Product Report Class
 *
 * @category Report
 * @package  ClientExec
 * @author   Juan D. Bolivar <juan@clientexec.com>
 * @license  ClientExec License
 * @version  1.0
 * @link     http://www.clientexec.com
 */
class Revenue_By_Product extends Report
{
    private $lang;

    protected $featureSet = 'billing';

    function __construct($user = null, $customer = null)
    {
        $this->lang = lang('Revenue by Product');
        parent::__construct($user, $customer);
    }

    /**
     * Report Process Method
     *
     * @return null - direct output
     */
    function process()
    {
        include_once 'modules/admin/models/StatusAliasGateway.php' ;

        // Set the report information
        $this->SetDescription($this->user->lang('Displays the total revenue between 2 dates broken down by products with the sum and revenue from each.'));

        // Load the currency information
        $currency = new Currency($this->user);

        $currencyCode = ((isset($_REQUEST['currencycode']))? $_REQUEST['currencycode'] : $this->settings->get('Default Currency'));
        $currencyName = $currency->getName($currencyCode);

        if (isset($_REQUEST['startdate'])) {
            $startDateArray = explode('/', $_REQUEST['startdate']);

            if ($this->settings->get('Date Format') == 'm/d/Y') {
                $tempStartDate = date("Y-m-d", mktime(0, 0, 0, $startDateArray[0], $startDateArray[1], $startDateArray[2]));
            } else {
                $tempStartDate = date("Y-m-d", mktime(0, 0, 0, $startDateArray[1], $startDateArray[0], $startDateArray[2]));
            }
        } else {
            $tempStartDate = date("Y-m-d", mktime(0, 0, 0, date("m"), 1, date("Y")-1));
        }

        if (isset($_REQUEST['enddate'])) {
            $endDateArray = explode('/', $_REQUEST['enddate']);

            if ($this->settings->get('Date Format') == 'm/d/Y') {
                $tempEndDate = date("Y-m-d", mktime(0, 0, 0, $endDateArray[0], $endDateArray[1], $endDateArray[2]));
            } else {
                $tempEndDate = date("Y-m-d", mktime(0, 0, 0, $endDateArray[1], $endDateArray[0], $endDateArray[2]));
            }
        } else {
            $tempEndDate = date("Y-m-d");
        }

        $filter = '<form id="report" method="GET">'
            .'    <div style="text-align:center">'
            .'        '.$this->user->lang('Date Paid').': '
            .'        <input class="datepicker" type="text" name="startdate" id="startdate" value=\''.CE_Lib::db_to_form($tempStartDate, $this->settings->get('Date Format'), "/").'\' />'
            .' - '
            .'<input class="datepicker" type="text" name="enddate" id="enddate" value=\''.CE_Lib::db_to_form($tempEndDate, $this->settings->get('Date Format'), "/").'\' />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'
            .'        '.$this->user->lang('Currency').': '
            .'        <select class="normalSelect2 w-25" name="currencycode" id="currencycode" value="'.CE_Lib::viewEscape($currencyCode).'" > ';

        $isSelectedCurrencyInTheList = false;

        //Get all currencies of all users
        $result = Capsule::table('users as u')
            ->join('currency as c', 'c.abrv', '=', 'u.currency')
            ->select('c.abrv', 'c.name')
            ->distinct()
            ->orderBy('c.name', 'ASC')
            ->get();

        foreach ($result as $row) {
            if (!$isSelectedCurrencyInTheList && $currencyName < $row->name) {
                $filter .= '<option value="'.$currencyCode.'" selected>'.$currencyName.'</option>';
                $isSelectedCurrencyInTheList = true;
            } elseif ($currencyCode == $row->abrv) {
                $isSelectedCurrencyInTheList = true;
            }

            $filter .= '<option value="'.$row->abrv.'" '.(($currencyCode == $row->abrv)? 'selected' : '').'>'.$row->name.'</option>';
        }

        if (!$isSelectedCurrencyInTheList) {
            $filter .= '<option value="'.$currencyCode.'" selected>'.$currencyName.'</option>';
            $isSelectedCurrencyInTheList = true;
        }

        $filter .= '</select>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'
            .'        <input type=button name=search class="cm-btns orange" value=\''.$this->user->lang('Search').'\' onclick="ChangeTable(document.getElementById(\'startdate\').value, document.getElementById(\'enddate\').value, document.getElementById(\'currencycode\').value);">';


        $filter .= '    </div>'
            .'</form>'
            .'</br>'
            .'<script type="text/javascript">'
            .'    function ChangeTable(startdate, enddate, currencycode){'
            .'        location.href="index.php?fuse=reports&view=viewreport&controller=index&report=Revenue+By+Product&type=Revenue&startdate="+encodeURIComponent(startdate)+"&enddate="+encodeURIComponent(enddate)+"&currencycode="+currencycode;'
            .'    }'
            .'</script>';
        echo $filter;

        $packageFirstPaidInvoice = array();

        $result = Capsule::table('invoiceentry as ie')
            ->join('invoice as i', 'ie.invoiceid', '=', 'i.id')
            ->selectRaw('MIN(i.id) as min_id, ie.appliestoid')
            ->whereIn('ie.billingtypeid', [
                BILLINGTYPE_PACKAGE,
                BILLINGTYPE_PACKAGE_UPGRADE
            ])
            ->where('i.currency', $currencyCode)
            ->where('i.status', INVOICE_STATUS_PAID)
            ->groupBy('ie.appliestoid')
            ->get();

        foreach ($result as $row) {
            $packageFirstPaidInvoice[$row->appliestoid] = $row->min_id;
        }

        $revenueByProductGroup = array();

        $result = Capsule::table('invoiceentry as ie')
            ->join('invoice as i', 'ie.invoiceid', '=', 'i.id')
            ->join('domains as d', 'ie.appliestoid', '=', 'd.id')
            ->join('package as p', 'd.Plan', '=', 'p.id')
            ->join('promotion as pr', 'p.planid', '=', 'pr.id')
            ->select(
                'ie.invoiceid',
                'ie.price',
                'ie.quantity',
                'ie.appliestoid',
                'i.datepaid',
                'p.planname as product_name',
                'pr.name as product_group_name'
            )
            ->whereIn('ie.billingtypeid', [
                BILLINGTYPE_PACKAGE,
                BILLINGTYPE_PACKAGE_UPGRADE
            ])
            ->where('i.currency', $currencyCode)
            ->where('i.status', INVOICE_STATUS_PAID)
            ->where('i.datepaid', '>=', $tempStartDate)
            ->where('i.datepaid', '<=', $tempEndDate . ' 23:59:59')
            ->get();

        // Fill array with the totals for paid invoice entries of the products in the date range
        foreach ($result as $row) {
            $invoice = new Invoice($row->invoiceid);
            $packageRevenue = $invoice->packageBillingDetailsFromInvoice($row->appliestoid);

            if (isset($revenueByProductGroup[$row->product_group_name][$row->product_name])) {
                if ($packageFirstPaidInvoice[$row->appliestoid] == $row->invoiceid) {
                    $revenueByProductGroup[$row->product_group_name][$row->product_name]["NewOrders"] += (float)$packageRevenue;
                } else {
                    $revenueByProductGroup[$row->product_group_name][$row->product_name]["Renewals"] += (float)$packageRevenue;
                }

                $revenueByProductGroup[$row->product_group_name][$row->product_name]["SumPerProduct"] += (float)$packageRevenue;
                $revenueByProductGroup[$row->product_group_name][$row->product_name]["NumberOfItems"] += (float)$row->quantity;
            } else {
                if ($packageFirstPaidInvoice[$row->appliestoid] == $row->invoiceid) {
                    $revenueByProductGroup[$row->product_group_name][$row->product_name]["NewOrders"] = (float)$packageRevenue;
                    $revenueByProductGroup[$row->product_group_name][$row->product_name]["Renewals"] = 0;
                } else {
                    $revenueByProductGroup[$row->product_group_name][$row->product_name]["NewOrders"] = 0;
                    $revenueByProductGroup[$row->product_group_name][$row->product_name]["Renewals"] = (float)$packageRevenue;
                }

                $revenueByProductGroup[$row->product_group_name][$row->product_name]["SumPerProduct"] = (float)$packageRevenue;
                $revenueByProductGroup[$row->product_group_name][$row->product_name]["NumberOfItems"] = (float)$row->quantity;
            }
        }

        foreach ($revenueByProductGroup as $tProductGroup => $revenueByProduct) {
            //initialize
            $revenueNewOrders = 0;
            $revenueRenewals = 0;
            $revenueTotal = 0;
            $itemTotal = 0;
            $aGroup = array();

            foreach ($revenueByProduct as $tProduct => $revenueByProductData) {
                $revenueNewOrders += $revenueByProductData["NewOrders"];
                $revenueRenewals += $revenueByProductData["Renewals"];
                $revenueTotal += $revenueByProductData["SumPerProduct"];
                $itemTotal += $revenueByProductData["NumberOfItems"];
                $aGroup[] = array($tProduct, $revenueByProductData["NumberOfItems"], $currency->format($currencyCode, $revenueByProductData["NewOrders"], true), $currency->format($currencyCode, $revenueByProductData["Renewals"], true), $currency->format($currencyCode, $revenueByProductData["SumPerProduct"], true));
            }

            $aGroup[] = array('', '', '');
            $aGroup[] = array('<b>'.$this->user->lang('Totals').'</b>', $itemTotal, $currency->format($currencyCode, $revenueNewOrders, true), $currency->format($currencyCode, $revenueRenewals, true), $currency->format($currencyCode, $revenueTotal, true));

            //add previous group before getting next group
            $this->reportData[] = array(
                "group"     => $aGroup,
                "groupname" => $tProductGroup.' ('.$currencyCode.')',
                "label"     => array($this->user->lang('Product'), $this->user->lang('Amount Sold'), $this->user->lang('New Orders Revenue'), $this->user->lang('Renewals Revenue'), $this->user->lang('Total Revenue')),
                'colStyle'  => 'width:200px',
                "groupId"   => "",
                "isHidden"  => false
            );
        }
    }
}
