<?php
/**
 * LoginsApi
 * PHP version 8.1
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * orchd
 *
 * orchd API docs
 *
 * The version of the OpenAPI document: 12.13.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.17.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use OpenAPI\Client\ApiException;
use OpenAPI\Client\Configuration;
use OpenAPI\Client\FormDataProcessor;
use OpenAPI\Client\HeaderSelector;
use OpenAPI\Client\ObjectSerializer;

/**
 * LoginsApi Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class LoginsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createLogin' => [
            'application/json',
        ],
        'createOtpSession' => [
            'application/json',
        ],
        'createSession' => [
            'application/json',
        ],
        'deleteCurrentSession' => [
            'application/json',
        ],
        'deleteLoginAvatar' => [
            'application/json',
        ],
        'deleteSession' => [
            'application/json',
        ],
        'deleteSessions' => [
            'application/json',
        ],
        'finishPasswordRecovery' => [
            'application/json',
        ],
        'getCustomerLogins' => [
            'application/json',
        ],
        'getLogin' => [
            'application/json',
        ],
        'getLoginMemberships' => [
            'application/json',
        ],
        'getLogins' => [
            'application/json',
        ],
        'getOrgLogins' => [
            'application/json',
        ],
        'getSessions' => [
            'application/json',
        ],
        'getUiPreferences' => [
            'application/json',
        ],
        'resendPin' => [
            'application/json',
        ],
        'setCustomerLoginPassword' => [
            'application/json',
        ],
        'setLoginAvatar' => [
            'multipart/form-data',
        ],
        'setUiPreferences' => [
            'application/json',
        ],
        'startPasswordRecovery' => [
            'application/json',
        ],
        'updateLoginInfo' => [
            'application/json',
        ],
        'updateUiPreferences' => [
            'application/json',
        ],
        'validatePasswordRecovery' => [
            'application/json',
        ],
        'verify2FA' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createLogin
     *
     * Create a new login
     *
     * @param  string $org_id The mandatory organization id to denote in which realm to create the login in. The login will be created in the same realm that the organization is in. (required)
     * @param  \OpenAPI\Client\Model\LoginInfo $login_info login_info (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createLogin'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\NewResourceUuid
     */
    public function createLogin($org_id, $login_info, string $contentType = self::contentTypes['createLogin'][0])
    {
        list($response) = $this->createLoginWithHttpInfo($org_id, $login_info, $contentType);
        return $response;
    }

    /**
     * Operation createLoginWithHttpInfo
     *
     * Create a new login
     *
     * @param  string $org_id The mandatory organization id to denote in which realm to create the login in. The login will be created in the same realm that the organization is in. (required)
     * @param  \OpenAPI\Client\Model\LoginInfo $login_info (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createLogin'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\NewResourceUuid, HTTP status code, HTTP response headers (array of strings)
     */
    public function createLoginWithHttpInfo($org_id, $login_info, string $contentType = self::contentTypes['createLogin'][0])
    {
        $request = $this->createLoginRequest($org_id, $login_info, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\NewResourceUuid',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\NewResourceUuid',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\NewResourceUuid',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation createLoginAsync
     *
     * Create a new login
     *
     * @param  string $org_id The mandatory organization id to denote in which realm to create the login in. The login will be created in the same realm that the organization is in. (required)
     * @param  \OpenAPI\Client\Model\LoginInfo $login_info (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createLogin'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createLoginAsync($org_id, $login_info, string $contentType = self::contentTypes['createLogin'][0])
    {
        return $this->createLoginAsyncWithHttpInfo($org_id, $login_info, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createLoginAsyncWithHttpInfo
     *
     * Create a new login
     *
     * @param  string $org_id The mandatory organization id to denote in which realm to create the login in. The login will be created in the same realm that the organization is in. (required)
     * @param  \OpenAPI\Client\Model\LoginInfo $login_info (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createLogin'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createLoginAsyncWithHttpInfo($org_id, $login_info, string $contentType = self::contentTypes['createLogin'][0])
    {
        $returnType = '\OpenAPI\Client\Model\NewResourceUuid';
        $request = $this->createLoginRequest($org_id, $login_info, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createLogin'
     *
     * @param  string $org_id The mandatory organization id to denote in which realm to create the login in. The login will be created in the same realm that the organization is in. (required)
     * @param  \OpenAPI\Client\Model\LoginInfo $login_info (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createLogin'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createLoginRequest($org_id, $login_info, string $contentType = self::contentTypes['createLogin'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling createLogin'
            );
        }

        // verify the required parameter 'login_info' is set
        if ($login_info === null || (is_array($login_info) && count($login_info) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $login_info when calling createLogin'
            );
        }


        $resourcePath = '/logins';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $org_id,
            'orgId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($login_info)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($login_info));
            } else {
                $httpBody = $login_info;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createOtpSession
     *
     * Create a new session for login with a one-time-password
     *
     * @param  string $otp Contains a short lived otp for direct login bypassing any 2FA. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOtpSession'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\LoginMemberships
     */
    public function createOtpSession($otp, string $contentType = self::contentTypes['createOtpSession'][0])
    {
        list($response) = $this->createOtpSessionWithHttpInfo($otp, $contentType);
        return $response;
    }

    /**
     * Operation createOtpSessionWithHttpInfo
     *
     * Create a new session for login with a one-time-password
     *
     * @param  string $otp Contains a short lived otp for direct login bypassing any 2FA. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOtpSession'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\LoginMemberships, HTTP status code, HTTP response headers (array of strings)
     */
    public function createOtpSessionWithHttpInfo($otp, string $contentType = self::contentTypes['createOtpSession'][0])
    {
        $request = $this->createOtpSessionRequest($otp, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\LoginMemberships',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\LoginMemberships',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\LoginMemberships',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation createOtpSessionAsync
     *
     * Create a new session for login with a one-time-password
     *
     * @param  string $otp Contains a short lived otp for direct login bypassing any 2FA. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOtpSession'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createOtpSessionAsync($otp, string $contentType = self::contentTypes['createOtpSession'][0])
    {
        return $this->createOtpSessionAsyncWithHttpInfo($otp, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createOtpSessionAsyncWithHttpInfo
     *
     * Create a new session for login with a one-time-password
     *
     * @param  string $otp Contains a short lived otp for direct login bypassing any 2FA. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOtpSession'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createOtpSessionAsyncWithHttpInfo($otp, string $contentType = self::contentTypes['createOtpSession'][0])
    {
        $returnType = '\OpenAPI\Client\Model\LoginMemberships';
        $request = $this->createOtpSessionRequest($otp, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createOtpSession'
     *
     * @param  string $otp Contains a short lived otp for direct login bypassing any 2FA. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOtpSession'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createOtpSessionRequest($otp, string $contentType = self::contentTypes['createOtpSession'][0])
    {

        // verify the required parameter 'otp' is set
        if ($otp === null || (is_array($otp) && count($otp) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $otp when calling createOtpSession'
            );
        }


        $resourcePath = '/login/sessions/sso';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $otp,
            'otp', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createSession
     *
     * Create a new session for login
     *
     * @param  \OpenAPI\Client\Model\LoginCreds $login_creds Login credentials. (required)
     * @param  string|null $realm_id If set with the given realm&#39;s id (the parent id of an organization), then the login is authenticated in this realm. See the endpoint description for more info. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSession'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\LoginMemberships|\OpenAPI\Client\Model\SessionResult
     */
    public function createSession($login_creds, $realm_id = null, string $contentType = self::contentTypes['createSession'][0])
    {
        list($response) = $this->createSessionWithHttpInfo($login_creds, $realm_id, $contentType);
        return $response;
    }

    /**
     * Operation createSessionWithHttpInfo
     *
     * Create a new session for login
     *
     * @param  \OpenAPI\Client\Model\LoginCreds $login_creds Login credentials. (required)
     * @param  string|null $realm_id If set with the given realm&#39;s id (the parent id of an organization), then the login is authenticated in this realm. See the endpoint description for more info. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSession'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\LoginMemberships|\OpenAPI\Client\Model\SessionResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function createSessionWithHttpInfo($login_creds, $realm_id = null, string $contentType = self::contentTypes['createSession'][0])
    {
        $request = $this->createSessionRequest($login_creds, $realm_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\LoginMemberships',
                        $request,
                        $response,
                    );
                case 201:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\SessionResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\LoginMemberships',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\LoginMemberships',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\SessionResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation createSessionAsync
     *
     * Create a new session for login
     *
     * @param  \OpenAPI\Client\Model\LoginCreds $login_creds Login credentials. (required)
     * @param  string|null $realm_id If set with the given realm&#39;s id (the parent id of an organization), then the login is authenticated in this realm. See the endpoint description for more info. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSession'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createSessionAsync($login_creds, $realm_id = null, string $contentType = self::contentTypes['createSession'][0])
    {
        return $this->createSessionAsyncWithHttpInfo($login_creds, $realm_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createSessionAsyncWithHttpInfo
     *
     * Create a new session for login
     *
     * @param  \OpenAPI\Client\Model\LoginCreds $login_creds Login credentials. (required)
     * @param  string|null $realm_id If set with the given realm&#39;s id (the parent id of an organization), then the login is authenticated in this realm. See the endpoint description for more info. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSession'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createSessionAsyncWithHttpInfo($login_creds, $realm_id = null, string $contentType = self::contentTypes['createSession'][0])
    {
        $returnType = '\OpenAPI\Client\Model\LoginMemberships';
        $request = $this->createSessionRequest($login_creds, $realm_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createSession'
     *
     * @param  \OpenAPI\Client\Model\LoginCreds $login_creds Login credentials. (required)
     * @param  string|null $realm_id If set with the given realm&#39;s id (the parent id of an organization), then the login is authenticated in this realm. See the endpoint description for more info. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSession'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createSessionRequest($login_creds, $realm_id = null, string $contentType = self::contentTypes['createSession'][0])
    {

        // verify the required parameter 'login_creds' is set
        if ($login_creds === null || (is_array($login_creds) && count($login_creds) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $login_creds when calling createSession'
            );
        }



        $resourcePath = '/login/sessions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $realm_id,
            'realmId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($login_creds)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($login_creds));
            } else {
                $httpBody = $login_creds;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteCurrentSession
     *
     * Delete current session
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCurrentSession'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteCurrentSession(string $contentType = self::contentTypes['deleteCurrentSession'][0])
    {
        $this->deleteCurrentSessionWithHttpInfo($contentType);
    }

    /**
     * Operation deleteCurrentSessionWithHttpInfo
     *
     * Delete current session
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCurrentSession'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteCurrentSessionWithHttpInfo(string $contentType = self::contentTypes['deleteCurrentSession'][0])
    {
        $request = $this->deleteCurrentSessionRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteCurrentSessionAsync
     *
     * Delete current session
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCurrentSession'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteCurrentSessionAsync(string $contentType = self::contentTypes['deleteCurrentSession'][0])
    {
        return $this->deleteCurrentSessionAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteCurrentSessionAsyncWithHttpInfo
     *
     * Delete current session
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCurrentSession'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteCurrentSessionAsyncWithHttpInfo(string $contentType = self::contentTypes['deleteCurrentSession'][0])
    {
        $returnType = '';
        $request = $this->deleteCurrentSessionRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteCurrentSession'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCurrentSession'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteCurrentSessionRequest(string $contentType = self::contentTypes['deleteCurrentSession'][0])
    {


        $resourcePath = '/login/sessions/current';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteLoginAvatar
     *
     * Remove login avatar
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteLoginAvatar'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteLoginAvatar(string $contentType = self::contentTypes['deleteLoginAvatar'][0])
    {
        $this->deleteLoginAvatarWithHttpInfo($contentType);
    }

    /**
     * Operation deleteLoginAvatarWithHttpInfo
     *
     * Remove login avatar
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteLoginAvatar'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteLoginAvatarWithHttpInfo(string $contentType = self::contentTypes['deleteLoginAvatar'][0])
    {
        $request = $this->deleteLoginAvatarRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteLoginAvatarAsync
     *
     * Remove login avatar
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteLoginAvatar'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteLoginAvatarAsync(string $contentType = self::contentTypes['deleteLoginAvatar'][0])
    {
        return $this->deleteLoginAvatarAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteLoginAvatarAsyncWithHttpInfo
     *
     * Remove login avatar
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteLoginAvatar'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteLoginAvatarAsyncWithHttpInfo(string $contentType = self::contentTypes['deleteLoginAvatar'][0])
    {
        $returnType = '';
        $request = $this->deleteLoginAvatarRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteLoginAvatar'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteLoginAvatar'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteLoginAvatarRequest(string $contentType = self::contentTypes['deleteLoginAvatar'][0])
    {


        $resourcePath = '/login/avatar';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteSession
     *
     * Delete current session
     *
     * @param  string $session_id The id of the login session. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSession'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteSession($session_id, string $contentType = self::contentTypes['deleteSession'][0])
    {
        $this->deleteSessionWithHttpInfo($session_id, $contentType);
    }

    /**
     * Operation deleteSessionWithHttpInfo
     *
     * Delete current session
     *
     * @param  string $session_id The id of the login session. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSession'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteSessionWithHttpInfo($session_id, string $contentType = self::contentTypes['deleteSession'][0])
    {
        $request = $this->deleteSessionRequest($session_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteSessionAsync
     *
     * Delete current session
     *
     * @param  string $session_id The id of the login session. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSession'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSessionAsync($session_id, string $contentType = self::contentTypes['deleteSession'][0])
    {
        return $this->deleteSessionAsyncWithHttpInfo($session_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteSessionAsyncWithHttpInfo
     *
     * Delete current session
     *
     * @param  string $session_id The id of the login session. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSession'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSessionAsyncWithHttpInfo($session_id, string $contentType = self::contentTypes['deleteSession'][0])
    {
        $returnType = '';
        $request = $this->deleteSessionRequest($session_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteSession'
     *
     * @param  string $session_id The id of the login session. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSession'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteSessionRequest($session_id, string $contentType = self::contentTypes['deleteSession'][0])
    {

        // verify the required parameter 'session_id' is set
        if ($session_id === null || (is_array($session_id) && count($session_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $session_id when calling deleteSession'
            );
        }


        $resourcePath = '/login/sessions/{session_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($session_id !== null) {
            $resourcePath = str_replace(
                '{' . 'session_id' . '}',
                ObjectSerializer::toPathValue($session_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteSessions
     *
     * Delete sessions
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSessions'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteSessions(string $contentType = self::contentTypes['deleteSessions'][0])
    {
        $this->deleteSessionsWithHttpInfo($contentType);
    }

    /**
     * Operation deleteSessionsWithHttpInfo
     *
     * Delete sessions
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSessions'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteSessionsWithHttpInfo(string $contentType = self::contentTypes['deleteSessions'][0])
    {
        $request = $this->deleteSessionsRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteSessionsAsync
     *
     * Delete sessions
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSessions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSessionsAsync(string $contentType = self::contentTypes['deleteSessions'][0])
    {
        return $this->deleteSessionsAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteSessionsAsyncWithHttpInfo
     *
     * Delete sessions
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSessions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSessionsAsyncWithHttpInfo(string $contentType = self::contentTypes['deleteSessions'][0])
    {
        $returnType = '';
        $request = $this->deleteSessionsRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteSessions'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSessions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteSessionsRequest(string $contentType = self::contentTypes['deleteSessions'][0])
    {


        $resourcePath = '/login/sessions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation finishPasswordRecovery
     *
     * Finish a password recovery
     *
     * @param  string $secret The secret key for the password recovery. (required)
     * @param  \OpenAPI\Client\Model\NewPassword $new_password Login&#39;s new password. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['finishPasswordRecovery'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function finishPasswordRecovery($secret, $new_password, string $contentType = self::contentTypes['finishPasswordRecovery'][0])
    {
        $this->finishPasswordRecoveryWithHttpInfo($secret, $new_password, $contentType);
    }

    /**
     * Operation finishPasswordRecoveryWithHttpInfo
     *
     * Finish a password recovery
     *
     * @param  string $secret The secret key for the password recovery. (required)
     * @param  \OpenAPI\Client\Model\NewPassword $new_password Login&#39;s new password. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['finishPasswordRecovery'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function finishPasswordRecoveryWithHttpInfo($secret, $new_password, string $contentType = self::contentTypes['finishPasswordRecovery'][0])
    {
        $request = $this->finishPasswordRecoveryRequest($secret, $new_password, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation finishPasswordRecoveryAsync
     *
     * Finish a password recovery
     *
     * @param  string $secret The secret key for the password recovery. (required)
     * @param  \OpenAPI\Client\Model\NewPassword $new_password Login&#39;s new password. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['finishPasswordRecovery'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function finishPasswordRecoveryAsync($secret, $new_password, string $contentType = self::contentTypes['finishPasswordRecovery'][0])
    {
        return $this->finishPasswordRecoveryAsyncWithHttpInfo($secret, $new_password, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation finishPasswordRecoveryAsyncWithHttpInfo
     *
     * Finish a password recovery
     *
     * @param  string $secret The secret key for the password recovery. (required)
     * @param  \OpenAPI\Client\Model\NewPassword $new_password Login&#39;s new password. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['finishPasswordRecovery'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function finishPasswordRecoveryAsyncWithHttpInfo($secret, $new_password, string $contentType = self::contentTypes['finishPasswordRecovery'][0])
    {
        $returnType = '';
        $request = $this->finishPasswordRecoveryRequest($secret, $new_password, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'finishPasswordRecovery'
     *
     * @param  string $secret The secret key for the password recovery. (required)
     * @param  \OpenAPI\Client\Model\NewPassword $new_password Login&#39;s new password. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['finishPasswordRecovery'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function finishPasswordRecoveryRequest($secret, $new_password, string $contentType = self::contentTypes['finishPasswordRecovery'][0])
    {

        // verify the required parameter 'secret' is set
        if ($secret === null || (is_array($secret) && count($secret) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $secret when calling finishPasswordRecovery'
            );
        }

        // verify the required parameter 'new_password' is set
        if ($new_password === null || (is_array($new_password) && count($new_password) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $new_password when calling finishPasswordRecovery'
            );
        }


        $resourcePath = '/login/password-recovery';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $secret,
            'secret', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($new_password)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($new_password));
            } else {
                $httpBody = $new_password;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getCustomerLogins
     *
     * List customer logins for org
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int|null $offset The offset from which to return items. (optional)
     * @param  int|null $limit The maximum number of items to return. (optional)
     * @param  string|null $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string|null $sort_by The field by which to sort. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomerLogins'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\LoginsListing
     */
    public function getCustomerLogins($org_id, $offset = null, $limit = null, $sort_order = null, $sort_by = null, string $contentType = self::contentTypes['getCustomerLogins'][0])
    {
        list($response) = $this->getCustomerLoginsWithHttpInfo($org_id, $offset, $limit, $sort_order, $sort_by, $contentType);
        return $response;
    }

    /**
     * Operation getCustomerLoginsWithHttpInfo
     *
     * List customer logins for org
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int|null $offset The offset from which to return items. (optional)
     * @param  int|null $limit The maximum number of items to return. (optional)
     * @param  string|null $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string|null $sort_by The field by which to sort. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomerLogins'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\LoginsListing, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCustomerLoginsWithHttpInfo($org_id, $offset = null, $limit = null, $sort_order = null, $sort_by = null, string $contentType = self::contentTypes['getCustomerLogins'][0])
    {
        $request = $this->getCustomerLoginsRequest($org_id, $offset, $limit, $sort_order, $sort_by, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\LoginsListing',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\LoginsListing',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\LoginsListing',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getCustomerLoginsAsync
     *
     * List customer logins for org
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int|null $offset The offset from which to return items. (optional)
     * @param  int|null $limit The maximum number of items to return. (optional)
     * @param  string|null $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string|null $sort_by The field by which to sort. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomerLogins'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCustomerLoginsAsync($org_id, $offset = null, $limit = null, $sort_order = null, $sort_by = null, string $contentType = self::contentTypes['getCustomerLogins'][0])
    {
        return $this->getCustomerLoginsAsyncWithHttpInfo($org_id, $offset, $limit, $sort_order, $sort_by, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getCustomerLoginsAsyncWithHttpInfo
     *
     * List customer logins for org
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int|null $offset The offset from which to return items. (optional)
     * @param  int|null $limit The maximum number of items to return. (optional)
     * @param  string|null $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string|null $sort_by The field by which to sort. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomerLogins'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCustomerLoginsAsyncWithHttpInfo($org_id, $offset = null, $limit = null, $sort_order = null, $sort_by = null, string $contentType = self::contentTypes['getCustomerLogins'][0])
    {
        $returnType = '\OpenAPI\Client\Model\LoginsListing';
        $request = $this->getCustomerLoginsRequest($org_id, $offset, $limit, $sort_order, $sort_by, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getCustomerLogins'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int|null $offset The offset from which to return items. (optional)
     * @param  int|null $limit The maximum number of items to return. (optional)
     * @param  string|null $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string|null $sort_by The field by which to sort. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomerLogins'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getCustomerLoginsRequest($org_id, $offset = null, $limit = null, $sort_order = null, $sort_by = null, string $contentType = self::contentTypes['getCustomerLogins'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getCustomerLogins'
            );
        }






        $resourcePath = '/v2/orgs/{org_id}/customers/logins';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $offset,
            'offset', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_order,
            'sortOrder', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_by,
            'sortBy', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getLogin
     *
     * Get login info
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getLogin'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\Login
     */
    public function getLogin(string $contentType = self::contentTypes['getLogin'][0])
    {
        list($response) = $this->getLoginWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getLoginWithHttpInfo
     *
     * Get login info
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getLogin'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Login, HTTP status code, HTTP response headers (array of strings)
     */
    public function getLoginWithHttpInfo(string $contentType = self::contentTypes['getLogin'][0])
    {
        $request = $this->getLoginRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Login',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Login',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Login',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getLoginAsync
     *
     * Get login info
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getLogin'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getLoginAsync(string $contentType = self::contentTypes['getLogin'][0])
    {
        return $this->getLoginAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getLoginAsyncWithHttpInfo
     *
     * Get login info
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getLogin'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getLoginAsyncWithHttpInfo(string $contentType = self::contentTypes['getLogin'][0])
    {
        $returnType = '\OpenAPI\Client\Model\Login';
        $request = $this->getLoginRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getLogin'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getLogin'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getLoginRequest(string $contentType = self::contentTypes['getLogin'][0])
    {


        $resourcePath = '/login';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getLoginMemberships
     *
     * Get login memberships
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getLoginMemberships'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\LoginMemberships
     */
    public function getLoginMemberships(string $contentType = self::contentTypes['getLoginMemberships'][0])
    {
        list($response) = $this->getLoginMembershipsWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getLoginMembershipsWithHttpInfo
     *
     * Get login memberships
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getLoginMemberships'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\LoginMemberships, HTTP status code, HTTP response headers (array of strings)
     */
    public function getLoginMembershipsWithHttpInfo(string $contentType = self::contentTypes['getLoginMemberships'][0])
    {
        $request = $this->getLoginMembershipsRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\LoginMemberships',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\LoginMemberships',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\LoginMemberships',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getLoginMembershipsAsync
     *
     * Get login memberships
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getLoginMemberships'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getLoginMembershipsAsync(string $contentType = self::contentTypes['getLoginMemberships'][0])
    {
        return $this->getLoginMembershipsAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getLoginMembershipsAsyncWithHttpInfo
     *
     * Get login memberships
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getLoginMemberships'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getLoginMembershipsAsyncWithHttpInfo(string $contentType = self::contentTypes['getLoginMemberships'][0])
    {
        $returnType = '\OpenAPI\Client\Model\LoginMemberships';
        $request = $this->getLoginMembershipsRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getLoginMemberships'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getLoginMemberships'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getLoginMembershipsRequest(string $contentType = self::contentTypes['getLoginMemberships'][0])
    {


        $resourcePath = '/login/memberships';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getLogins
     *
     * Query all logins
     *
     * @param  string|null $realm_id The id of the realm to query. Realm ids map to org ids. (optional)
     * @param  int|null $offset The offset from which to return items. (optional)
     * @param  int|null $limit The maximum number of items to return. (optional)
     * @param  string|null $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string|null $sort_by The field by which to sort. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getLogins'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\LoginsListing
     */
    public function getLogins($realm_id = null, $offset = null, $limit = null, $sort_order = null, $sort_by = null, string $contentType = self::contentTypes['getLogins'][0])
    {
        list($response) = $this->getLoginsWithHttpInfo($realm_id, $offset, $limit, $sort_order, $sort_by, $contentType);
        return $response;
    }

    /**
     * Operation getLoginsWithHttpInfo
     *
     * Query all logins
     *
     * @param  string|null $realm_id The id of the realm to query. Realm ids map to org ids. (optional)
     * @param  int|null $offset The offset from which to return items. (optional)
     * @param  int|null $limit The maximum number of items to return. (optional)
     * @param  string|null $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string|null $sort_by The field by which to sort. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getLogins'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\LoginsListing, HTTP status code, HTTP response headers (array of strings)
     */
    public function getLoginsWithHttpInfo($realm_id = null, $offset = null, $limit = null, $sort_order = null, $sort_by = null, string $contentType = self::contentTypes['getLogins'][0])
    {
        $request = $this->getLoginsRequest($realm_id, $offset, $limit, $sort_order, $sort_by, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\LoginsListing',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\LoginsListing',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\LoginsListing',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getLoginsAsync
     *
     * Query all logins
     *
     * @param  string|null $realm_id The id of the realm to query. Realm ids map to org ids. (optional)
     * @param  int|null $offset The offset from which to return items. (optional)
     * @param  int|null $limit The maximum number of items to return. (optional)
     * @param  string|null $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string|null $sort_by The field by which to sort. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getLogins'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getLoginsAsync($realm_id = null, $offset = null, $limit = null, $sort_order = null, $sort_by = null, string $contentType = self::contentTypes['getLogins'][0])
    {
        return $this->getLoginsAsyncWithHttpInfo($realm_id, $offset, $limit, $sort_order, $sort_by, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getLoginsAsyncWithHttpInfo
     *
     * Query all logins
     *
     * @param  string|null $realm_id The id of the realm to query. Realm ids map to org ids. (optional)
     * @param  int|null $offset The offset from which to return items. (optional)
     * @param  int|null $limit The maximum number of items to return. (optional)
     * @param  string|null $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string|null $sort_by The field by which to sort. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getLogins'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getLoginsAsyncWithHttpInfo($realm_id = null, $offset = null, $limit = null, $sort_order = null, $sort_by = null, string $contentType = self::contentTypes['getLogins'][0])
    {
        $returnType = '\OpenAPI\Client\Model\LoginsListing';
        $request = $this->getLoginsRequest($realm_id, $offset, $limit, $sort_order, $sort_by, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getLogins'
     *
     * @param  string|null $realm_id The id of the realm to query. Realm ids map to org ids. (optional)
     * @param  int|null $offset The offset from which to return items. (optional)
     * @param  int|null $limit The maximum number of items to return. (optional)
     * @param  string|null $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string|null $sort_by The field by which to sort. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getLogins'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getLoginsRequest($realm_id = null, $offset = null, $limit = null, $sort_order = null, $sort_by = null, string $contentType = self::contentTypes['getLogins'][0])
    {







        $resourcePath = '/logins';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $realm_id,
            'realmId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $offset,
            'offset', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_order,
            'sortOrder', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_by,
            'sortBy', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrgLogins
     *
     * Query logins belonging to organization
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int|null $offset The offset from which to return items. (optional)
     * @param  int|null $limit The maximum number of items to return. (optional)
     * @param  string|null $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string|null $sort_by The field by which to sort. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrgLogins'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\LoginsListing
     */
    public function getOrgLogins($org_id, $offset = null, $limit = null, $sort_order = null, $sort_by = null, string $contentType = self::contentTypes['getOrgLogins'][0])
    {
        list($response) = $this->getOrgLoginsWithHttpInfo($org_id, $offset, $limit, $sort_order, $sort_by, $contentType);
        return $response;
    }

    /**
     * Operation getOrgLoginsWithHttpInfo
     *
     * Query logins belonging to organization
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int|null $offset The offset from which to return items. (optional)
     * @param  int|null $limit The maximum number of items to return. (optional)
     * @param  string|null $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string|null $sort_by The field by which to sort. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrgLogins'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\LoginsListing, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrgLoginsWithHttpInfo($org_id, $offset = null, $limit = null, $sort_order = null, $sort_by = null, string $contentType = self::contentTypes['getOrgLogins'][0])
    {
        $request = $this->getOrgLoginsRequest($org_id, $offset, $limit, $sort_order, $sort_by, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\LoginsListing',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\LoginsListing',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\LoginsListing',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getOrgLoginsAsync
     *
     * Query logins belonging to organization
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int|null $offset The offset from which to return items. (optional)
     * @param  int|null $limit The maximum number of items to return. (optional)
     * @param  string|null $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string|null $sort_by The field by which to sort. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrgLogins'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrgLoginsAsync($org_id, $offset = null, $limit = null, $sort_order = null, $sort_by = null, string $contentType = self::contentTypes['getOrgLogins'][0])
    {
        return $this->getOrgLoginsAsyncWithHttpInfo($org_id, $offset, $limit, $sort_order, $sort_by, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrgLoginsAsyncWithHttpInfo
     *
     * Query logins belonging to organization
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int|null $offset The offset from which to return items. (optional)
     * @param  int|null $limit The maximum number of items to return. (optional)
     * @param  string|null $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string|null $sort_by The field by which to sort. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrgLogins'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrgLoginsAsyncWithHttpInfo($org_id, $offset = null, $limit = null, $sort_order = null, $sort_by = null, string $contentType = self::contentTypes['getOrgLogins'][0])
    {
        $returnType = '\OpenAPI\Client\Model\LoginsListing';
        $request = $this->getOrgLoginsRequest($org_id, $offset, $limit, $sort_order, $sort_by, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrgLogins'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int|null $offset The offset from which to return items. (optional)
     * @param  int|null $limit The maximum number of items to return. (optional)
     * @param  string|null $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string|null $sort_by The field by which to sort. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrgLogins'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrgLoginsRequest($org_id, $offset = null, $limit = null, $sort_order = null, $sort_by = null, string $contentType = self::contentTypes['getOrgLogins'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getOrgLogins'
            );
        }






        $resourcePath = '/orgs/{org_id}/logins';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $offset,
            'offset', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_order,
            'sortOrder', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_by,
            'sortBy', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSessions
     *
     * Get all login sessions
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSessions'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\SessionsFullListing
     */
    public function getSessions(string $contentType = self::contentTypes['getSessions'][0])
    {
        list($response) = $this->getSessionsWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getSessionsWithHttpInfo
     *
     * Get all login sessions
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSessions'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\SessionsFullListing, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSessionsWithHttpInfo(string $contentType = self::contentTypes['getSessions'][0])
    {
        $request = $this->getSessionsRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\SessionsFullListing',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\SessionsFullListing',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\SessionsFullListing',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getSessionsAsync
     *
     * Get all login sessions
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSessions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSessionsAsync(string $contentType = self::contentTypes['getSessions'][0])
    {
        return $this->getSessionsAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSessionsAsyncWithHttpInfo
     *
     * Get all login sessions
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSessions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSessionsAsyncWithHttpInfo(string $contentType = self::contentTypes['getSessions'][0])
    {
        $returnType = '\OpenAPI\Client\Model\SessionsFullListing';
        $request = $this->getSessionsRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSessions'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSessions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSessionsRequest(string $contentType = self::contentTypes['getSessions'][0])
    {


        $resourcePath = '/login/sessions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getUiPreferences
     *
     * Get UI prefereces for login
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getUiPreferences'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\UiPreferences
     */
    public function getUiPreferences(string $contentType = self::contentTypes['getUiPreferences'][0])
    {
        list($response) = $this->getUiPreferencesWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getUiPreferencesWithHttpInfo
     *
     * Get UI prefereces for login
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getUiPreferences'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\UiPreferences, HTTP status code, HTTP response headers (array of strings)
     */
    public function getUiPreferencesWithHttpInfo(string $contentType = self::contentTypes['getUiPreferences'][0])
    {
        $request = $this->getUiPreferencesRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\UiPreferences',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\UiPreferences',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\UiPreferences',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getUiPreferencesAsync
     *
     * Get UI prefereces for login
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getUiPreferences'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getUiPreferencesAsync(string $contentType = self::contentTypes['getUiPreferences'][0])
    {
        return $this->getUiPreferencesAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getUiPreferencesAsyncWithHttpInfo
     *
     * Get UI prefereces for login
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getUiPreferences'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getUiPreferencesAsyncWithHttpInfo(string $contentType = self::contentTypes['getUiPreferences'][0])
    {
        $returnType = '\OpenAPI\Client\Model\UiPreferences';
        $request = $this->getUiPreferencesRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getUiPreferences'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getUiPreferences'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getUiPreferencesRequest(string $contentType = self::contentTypes['getUiPreferences'][0])
    {


        $resourcePath = '/logins/ui-preferences';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation resendPin
     *
     * Resends 2FA sign-in code.
     *
     * @param  \OpenAPI\Client\Model\ResendPin $resend_pin Verification details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['resendPin'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function resendPin($resend_pin, string $contentType = self::contentTypes['resendPin'][0])
    {
        $this->resendPinWithHttpInfo($resend_pin, $contentType);
    }

    /**
     * Operation resendPinWithHttpInfo
     *
     * Resends 2FA sign-in code.
     *
     * @param  \OpenAPI\Client\Model\ResendPin $resend_pin Verification details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['resendPin'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function resendPinWithHttpInfo($resend_pin, string $contentType = self::contentTypes['resendPin'][0])
    {
        $request = $this->resendPinRequest($resend_pin, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation resendPinAsync
     *
     * Resends 2FA sign-in code.
     *
     * @param  \OpenAPI\Client\Model\ResendPin $resend_pin Verification details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['resendPin'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function resendPinAsync($resend_pin, string $contentType = self::contentTypes['resendPin'][0])
    {
        return $this->resendPinAsyncWithHttpInfo($resend_pin, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation resendPinAsyncWithHttpInfo
     *
     * Resends 2FA sign-in code.
     *
     * @param  \OpenAPI\Client\Model\ResendPin $resend_pin Verification details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['resendPin'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function resendPinAsyncWithHttpInfo($resend_pin, string $contentType = self::contentTypes['resendPin'][0])
    {
        $returnType = '';
        $request = $this->resendPinRequest($resend_pin, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'resendPin'
     *
     * @param  \OpenAPI\Client\Model\ResendPin $resend_pin Verification details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['resendPin'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function resendPinRequest($resend_pin, string $contentType = self::contentTypes['resendPin'][0])
    {

        // verify the required parameter 'resend_pin' is set
        if ($resend_pin === null || (is_array($resend_pin) && count($resend_pin) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $resend_pin when calling resendPin'
            );
        }


        $resourcePath = '/login/2fa/resend-pin';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($resend_pin)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($resend_pin));
            } else {
                $httpBody = $resend_pin;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setCustomerLoginPassword
     *
     * Set password for login
     *
     * @param  string $login_id The id of a login. (required)
     * @param  \OpenAPI\Client\Model\NewPassword $new_password The new unhashed password to set for the login (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setCustomerLoginPassword'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setCustomerLoginPassword($login_id, $new_password, string $contentType = self::contentTypes['setCustomerLoginPassword'][0])
    {
        $this->setCustomerLoginPasswordWithHttpInfo($login_id, $new_password, $contentType);
    }

    /**
     * Operation setCustomerLoginPasswordWithHttpInfo
     *
     * Set password for login
     *
     * @param  string $login_id The id of a login. (required)
     * @param  \OpenAPI\Client\Model\NewPassword $new_password The new unhashed password to set for the login (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setCustomerLoginPassword'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setCustomerLoginPasswordWithHttpInfo($login_id, $new_password, string $contentType = self::contentTypes['setCustomerLoginPassword'][0])
    {
        $request = $this->setCustomerLoginPasswordRequest($login_id, $new_password, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation setCustomerLoginPasswordAsync
     *
     * Set password for login
     *
     * @param  string $login_id The id of a login. (required)
     * @param  \OpenAPI\Client\Model\NewPassword $new_password The new unhashed password to set for the login (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setCustomerLoginPassword'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setCustomerLoginPasswordAsync($login_id, $new_password, string $contentType = self::contentTypes['setCustomerLoginPassword'][0])
    {
        return $this->setCustomerLoginPasswordAsyncWithHttpInfo($login_id, $new_password, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setCustomerLoginPasswordAsyncWithHttpInfo
     *
     * Set password for login
     *
     * @param  string $login_id The id of a login. (required)
     * @param  \OpenAPI\Client\Model\NewPassword $new_password The new unhashed password to set for the login (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setCustomerLoginPassword'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setCustomerLoginPasswordAsyncWithHttpInfo($login_id, $new_password, string $contentType = self::contentTypes['setCustomerLoginPassword'][0])
    {
        $returnType = '';
        $request = $this->setCustomerLoginPasswordRequest($login_id, $new_password, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setCustomerLoginPassword'
     *
     * @param  string $login_id The id of a login. (required)
     * @param  \OpenAPI\Client\Model\NewPassword $new_password The new unhashed password to set for the login (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setCustomerLoginPassword'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setCustomerLoginPasswordRequest($login_id, $new_password, string $contentType = self::contentTypes['setCustomerLoginPassword'][0])
    {

        // verify the required parameter 'login_id' is set
        if ($login_id === null || (is_array($login_id) && count($login_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $login_id when calling setCustomerLoginPassword'
            );
        }

        // verify the required parameter 'new_password' is set
        if ($new_password === null || (is_array($new_password) && count($new_password) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $new_password when calling setCustomerLoginPassword'
            );
        }


        $resourcePath = '/v2/logins/{login_id}/password';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($login_id !== null) {
            $resourcePath = str_replace(
                '{' . 'login_id' . '}',
                ObjectSerializer::toPathValue($login_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($new_password)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($new_password));
            } else {
                $httpBody = $new_password;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setLoginAvatar
     *
     * Set login avatar
     *
     * @param  \SplFileObject|null $avatar avatar (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setLoginAvatar'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setLoginAvatar($avatar = null, string $contentType = self::contentTypes['setLoginAvatar'][0])
    {
        $this->setLoginAvatarWithHttpInfo($avatar, $contentType);
    }

    /**
     * Operation setLoginAvatarWithHttpInfo
     *
     * Set login avatar
     *
     * @param  \SplFileObject|null $avatar (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setLoginAvatar'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setLoginAvatarWithHttpInfo($avatar = null, string $contentType = self::contentTypes['setLoginAvatar'][0])
    {
        $request = $this->setLoginAvatarRequest($avatar, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation setLoginAvatarAsync
     *
     * Set login avatar
     *
     * @param  \SplFileObject|null $avatar (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setLoginAvatar'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setLoginAvatarAsync($avatar = null, string $contentType = self::contentTypes['setLoginAvatar'][0])
    {
        return $this->setLoginAvatarAsyncWithHttpInfo($avatar, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setLoginAvatarAsyncWithHttpInfo
     *
     * Set login avatar
     *
     * @param  \SplFileObject|null $avatar (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setLoginAvatar'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setLoginAvatarAsyncWithHttpInfo($avatar = null, string $contentType = self::contentTypes['setLoginAvatar'][0])
    {
        $returnType = '';
        $request = $this->setLoginAvatarRequest($avatar, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setLoginAvatar'
     *
     * @param  \SplFileObject|null $avatar (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setLoginAvatar'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setLoginAvatarRequest($avatar = null, string $contentType = self::contentTypes['setLoginAvatar'][0])
    {



        $resourcePath = '/login/avatar';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;




        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'avatar' => $avatar,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $multipart = true;
        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setUiPreferences
     *
     * Set new UI prefereces for login
     *
     * @param  \OpenAPI\Client\Model\NewUiPreferences $new_ui_preferences new_ui_preferences (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setUiPreferences'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setUiPreferences($new_ui_preferences, string $contentType = self::contentTypes['setUiPreferences'][0])
    {
        $this->setUiPreferencesWithHttpInfo($new_ui_preferences, $contentType);
    }

    /**
     * Operation setUiPreferencesWithHttpInfo
     *
     * Set new UI prefereces for login
     *
     * @param  \OpenAPI\Client\Model\NewUiPreferences $new_ui_preferences (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setUiPreferences'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setUiPreferencesWithHttpInfo($new_ui_preferences, string $contentType = self::contentTypes['setUiPreferences'][0])
    {
        $request = $this->setUiPreferencesRequest($new_ui_preferences, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation setUiPreferencesAsync
     *
     * Set new UI prefereces for login
     *
     * @param  \OpenAPI\Client\Model\NewUiPreferences $new_ui_preferences (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setUiPreferences'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setUiPreferencesAsync($new_ui_preferences, string $contentType = self::contentTypes['setUiPreferences'][0])
    {
        return $this->setUiPreferencesAsyncWithHttpInfo($new_ui_preferences, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setUiPreferencesAsyncWithHttpInfo
     *
     * Set new UI prefereces for login
     *
     * @param  \OpenAPI\Client\Model\NewUiPreferences $new_ui_preferences (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setUiPreferences'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setUiPreferencesAsyncWithHttpInfo($new_ui_preferences, string $contentType = self::contentTypes['setUiPreferences'][0])
    {
        $returnType = '';
        $request = $this->setUiPreferencesRequest($new_ui_preferences, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setUiPreferences'
     *
     * @param  \OpenAPI\Client\Model\NewUiPreferences $new_ui_preferences (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setUiPreferences'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setUiPreferencesRequest($new_ui_preferences, string $contentType = self::contentTypes['setUiPreferences'][0])
    {

        // verify the required parameter 'new_ui_preferences' is set
        if ($new_ui_preferences === null || (is_array($new_ui_preferences) && count($new_ui_preferences) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $new_ui_preferences when calling setUiPreferences'
            );
        }


        $resourcePath = '/logins/ui-preferences';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($new_ui_preferences)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($new_ui_preferences));
            } else {
                $httpBody = $new_ui_preferences;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation startPasswordRecovery
     *
     * Start a new password recovery for login
     *
     * @param  \OpenAPI\Client\Model\EmailAddress $email_address Login&#39;s email address. (required)
     * @param  string|null $realm_id If set, the login is looked up in the specified realm. If unset then the chosen realm will be based on the control panel hostname. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['startPasswordRecovery'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function startPasswordRecovery($email_address, $realm_id = null, string $contentType = self::contentTypes['startPasswordRecovery'][0])
    {
        $this->startPasswordRecoveryWithHttpInfo($email_address, $realm_id, $contentType);
    }

    /**
     * Operation startPasswordRecoveryWithHttpInfo
     *
     * Start a new password recovery for login
     *
     * @param  \OpenAPI\Client\Model\EmailAddress $email_address Login&#39;s email address. (required)
     * @param  string|null $realm_id If set, the login is looked up in the specified realm. If unset then the chosen realm will be based on the control panel hostname. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['startPasswordRecovery'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function startPasswordRecoveryWithHttpInfo($email_address, $realm_id = null, string $contentType = self::contentTypes['startPasswordRecovery'][0])
    {
        $request = $this->startPasswordRecoveryRequest($email_address, $realm_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation startPasswordRecoveryAsync
     *
     * Start a new password recovery for login
     *
     * @param  \OpenAPI\Client\Model\EmailAddress $email_address Login&#39;s email address. (required)
     * @param  string|null $realm_id If set, the login is looked up in the specified realm. If unset then the chosen realm will be based on the control panel hostname. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['startPasswordRecovery'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function startPasswordRecoveryAsync($email_address, $realm_id = null, string $contentType = self::contentTypes['startPasswordRecovery'][0])
    {
        return $this->startPasswordRecoveryAsyncWithHttpInfo($email_address, $realm_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation startPasswordRecoveryAsyncWithHttpInfo
     *
     * Start a new password recovery for login
     *
     * @param  \OpenAPI\Client\Model\EmailAddress $email_address Login&#39;s email address. (required)
     * @param  string|null $realm_id If set, the login is looked up in the specified realm. If unset then the chosen realm will be based on the control panel hostname. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['startPasswordRecovery'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function startPasswordRecoveryAsyncWithHttpInfo($email_address, $realm_id = null, string $contentType = self::contentTypes['startPasswordRecovery'][0])
    {
        $returnType = '';
        $request = $this->startPasswordRecoveryRequest($email_address, $realm_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'startPasswordRecovery'
     *
     * @param  \OpenAPI\Client\Model\EmailAddress $email_address Login&#39;s email address. (required)
     * @param  string|null $realm_id If set, the login is looked up in the specified realm. If unset then the chosen realm will be based on the control panel hostname. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['startPasswordRecovery'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function startPasswordRecoveryRequest($email_address, $realm_id = null, string $contentType = self::contentTypes['startPasswordRecovery'][0])
    {

        // verify the required parameter 'email_address' is set
        if ($email_address === null || (is_array($email_address) && count($email_address) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $email_address when calling startPasswordRecovery'
            );
        }



        $resourcePath = '/login/password-recovery';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $realm_id,
            'realmId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($email_address)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($email_address));
            } else {
                $httpBody = $email_address;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateLoginInfo
     *
     * Update login info
     *
     * @param  \OpenAPI\Client\Model\UpdateLogin $update_login update_login (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateLoginInfo'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\UpdateLoginResult
     */
    public function updateLoginInfo($update_login, string $contentType = self::contentTypes['updateLoginInfo'][0])
    {
        list($response) = $this->updateLoginInfoWithHttpInfo($update_login, $contentType);
        return $response;
    }

    /**
     * Operation updateLoginInfoWithHttpInfo
     *
     * Update login info
     *
     * @param  \OpenAPI\Client\Model\UpdateLogin $update_login (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateLoginInfo'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\UpdateLoginResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateLoginInfoWithHttpInfo($update_login, string $contentType = self::contentTypes['updateLoginInfo'][0])
    {
        $request = $this->updateLoginInfoRequest($update_login, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\UpdateLoginResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\UpdateLoginResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\UpdateLoginResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateLoginInfoAsync
     *
     * Update login info
     *
     * @param  \OpenAPI\Client\Model\UpdateLogin $update_login (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateLoginInfo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateLoginInfoAsync($update_login, string $contentType = self::contentTypes['updateLoginInfo'][0])
    {
        return $this->updateLoginInfoAsyncWithHttpInfo($update_login, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateLoginInfoAsyncWithHttpInfo
     *
     * Update login info
     *
     * @param  \OpenAPI\Client\Model\UpdateLogin $update_login (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateLoginInfo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateLoginInfoAsyncWithHttpInfo($update_login, string $contentType = self::contentTypes['updateLoginInfo'][0])
    {
        $returnType = '\OpenAPI\Client\Model\UpdateLoginResult';
        $request = $this->updateLoginInfoRequest($update_login, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateLoginInfo'
     *
     * @param  \OpenAPI\Client\Model\UpdateLogin $update_login (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateLoginInfo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateLoginInfoRequest($update_login, string $contentType = self::contentTypes['updateLoginInfo'][0])
    {

        // verify the required parameter 'update_login' is set
        if ($update_login === null || (is_array($update_login) && count($update_login) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $update_login when calling updateLoginInfo'
            );
        }


        $resourcePath = '/login';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($update_login)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($update_login));
            } else {
                $httpBody = $update_login;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateUiPreferences
     *
     * Update UI prefereces for login
     *
     * @param  \OpenAPI\Client\Model\UpdateUiPreferences $update_ui_preferences update_ui_preferences (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateUiPreferences'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateUiPreferences($update_ui_preferences, string $contentType = self::contentTypes['updateUiPreferences'][0])
    {
        $this->updateUiPreferencesWithHttpInfo($update_ui_preferences, $contentType);
    }

    /**
     * Operation updateUiPreferencesWithHttpInfo
     *
     * Update UI prefereces for login
     *
     * @param  \OpenAPI\Client\Model\UpdateUiPreferences $update_ui_preferences (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateUiPreferences'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateUiPreferencesWithHttpInfo($update_ui_preferences, string $contentType = self::contentTypes['updateUiPreferences'][0])
    {
        $request = $this->updateUiPreferencesRequest($update_ui_preferences, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateUiPreferencesAsync
     *
     * Update UI prefereces for login
     *
     * @param  \OpenAPI\Client\Model\UpdateUiPreferences $update_ui_preferences (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateUiPreferences'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateUiPreferencesAsync($update_ui_preferences, string $contentType = self::contentTypes['updateUiPreferences'][0])
    {
        return $this->updateUiPreferencesAsyncWithHttpInfo($update_ui_preferences, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateUiPreferencesAsyncWithHttpInfo
     *
     * Update UI prefereces for login
     *
     * @param  \OpenAPI\Client\Model\UpdateUiPreferences $update_ui_preferences (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateUiPreferences'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateUiPreferencesAsyncWithHttpInfo($update_ui_preferences, string $contentType = self::contentTypes['updateUiPreferences'][0])
    {
        $returnType = '';
        $request = $this->updateUiPreferencesRequest($update_ui_preferences, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateUiPreferences'
     *
     * @param  \OpenAPI\Client\Model\UpdateUiPreferences $update_ui_preferences (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateUiPreferences'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateUiPreferencesRequest($update_ui_preferences, string $contentType = self::contentTypes['updateUiPreferences'][0])
    {

        // verify the required parameter 'update_ui_preferences' is set
        if ($update_ui_preferences === null || (is_array($update_ui_preferences) && count($update_ui_preferences) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $update_ui_preferences when calling updateUiPreferences'
            );
        }


        $resourcePath = '/logins/ui-preferences';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($update_ui_preferences)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($update_ui_preferences));
            } else {
                $httpBody = $update_ui_preferences;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation validatePasswordRecovery
     *
     * Validate a password recovery secret
     *
     * @param  string $secret The secret key for the password recovery. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['validatePasswordRecovery'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\ValidatedPasswordRecovery
     */
    public function validatePasswordRecovery($secret, string $contentType = self::contentTypes['validatePasswordRecovery'][0])
    {
        list($response) = $this->validatePasswordRecoveryWithHttpInfo($secret, $contentType);
        return $response;
    }

    /**
     * Operation validatePasswordRecoveryWithHttpInfo
     *
     * Validate a password recovery secret
     *
     * @param  string $secret The secret key for the password recovery. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['validatePasswordRecovery'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\ValidatedPasswordRecovery, HTTP status code, HTTP response headers (array of strings)
     */
    public function validatePasswordRecoveryWithHttpInfo($secret, string $contentType = self::contentTypes['validatePasswordRecovery'][0])
    {
        $request = $this->validatePasswordRecoveryRequest($secret, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ValidatedPasswordRecovery',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\ValidatedPasswordRecovery',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ValidatedPasswordRecovery',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation validatePasswordRecoveryAsync
     *
     * Validate a password recovery secret
     *
     * @param  string $secret The secret key for the password recovery. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['validatePasswordRecovery'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function validatePasswordRecoveryAsync($secret, string $contentType = self::contentTypes['validatePasswordRecovery'][0])
    {
        return $this->validatePasswordRecoveryAsyncWithHttpInfo($secret, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation validatePasswordRecoveryAsyncWithHttpInfo
     *
     * Validate a password recovery secret
     *
     * @param  string $secret The secret key for the password recovery. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['validatePasswordRecovery'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function validatePasswordRecoveryAsyncWithHttpInfo($secret, string $contentType = self::contentTypes['validatePasswordRecovery'][0])
    {
        $returnType = '\OpenAPI\Client\Model\ValidatedPasswordRecovery';
        $request = $this->validatePasswordRecoveryRequest($secret, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'validatePasswordRecovery'
     *
     * @param  string $secret The secret key for the password recovery. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['validatePasswordRecovery'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function validatePasswordRecoveryRequest($secret, string $contentType = self::contentTypes['validatePasswordRecovery'][0])
    {

        // verify the required parameter 'secret' is set
        if ($secret === null || (is_array($secret) && count($secret) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $secret when calling validatePasswordRecovery'
            );
        }


        $resourcePath = '/login/password-recovery/validate';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $secret,
            'secret', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation verify2FA
     *
     * Verifies 2FA sign-in code.
     *
     * @param  \OpenAPI\Client\Model\Login2FA $login2_fa Verification details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['verify2FA'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function verify2FA($login2_fa, string $contentType = self::contentTypes['verify2FA'][0])
    {
        $this->verify2FAWithHttpInfo($login2_fa, $contentType);
    }

    /**
     * Operation verify2FAWithHttpInfo
     *
     * Verifies 2FA sign-in code.
     *
     * @param  \OpenAPI\Client\Model\Login2FA $login2_fa Verification details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['verify2FA'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function verify2FAWithHttpInfo($login2_fa, string $contentType = self::contentTypes['verify2FA'][0])
    {
        $request = $this->verify2FARequest($login2_fa, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation verify2FAAsync
     *
     * Verifies 2FA sign-in code.
     *
     * @param  \OpenAPI\Client\Model\Login2FA $login2_fa Verification details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['verify2FA'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function verify2FAAsync($login2_fa, string $contentType = self::contentTypes['verify2FA'][0])
    {
        return $this->verify2FAAsyncWithHttpInfo($login2_fa, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation verify2FAAsyncWithHttpInfo
     *
     * Verifies 2FA sign-in code.
     *
     * @param  \OpenAPI\Client\Model\Login2FA $login2_fa Verification details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['verify2FA'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function verify2FAAsyncWithHttpInfo($login2_fa, string $contentType = self::contentTypes['verify2FA'][0])
    {
        $returnType = '';
        $request = $this->verify2FARequest($login2_fa, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'verify2FA'
     *
     * @param  \OpenAPI\Client\Model\Login2FA $login2_fa Verification details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['verify2FA'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function verify2FARequest($login2_fa, string $contentType = self::contentTypes['verify2FA'][0])
    {

        // verify the required parameter 'login2_fa' is set
        if ($login2_fa === null || (is_array($login2_fa) && count($login2_fa) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $login2_fa when calling verify2FA'
            );
        }


        $resourcePath = '/login/2fa';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($login2_fa)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($login2_fa));
            } else {
                $httpBody = $login2_fa;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        if ($this->config->getCertFile()) {
            $options[RequestOptions::CERT] = $this->config->getCertFile();
        }

        if ($this->config->getKeyFile()) {
            $options[RequestOptions::SSL_KEY] = $this->config->getKeyFile();
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
