<?php
/**
 * WordpressApi
 * PHP version 8.1
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * orchd
 *
 * orchd API docs
 *
 * The version of the OpenAPI document: 12.13.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.17.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use OpenAPI\Client\ApiException;
use OpenAPI\Client\Configuration;
use OpenAPI\Client\FormDataProcessor;
use OpenAPI\Client\HeaderSelector;
use OpenAPI\Client\ObjectSerializer;

/**
 * WordpressApi Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class WordpressApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'activateWordpressTheme' => [
            'application/json',
        ],
        'createWordpressUser' => [
            'application/json',
        ],
        'deleteWordpressPlugin' => [
            'application/json',
        ],
        'deleteWordpressTheme' => [
            'application/json',
        ],
        'deleteWordpressUser' => [
            'application/json',
        ],
        'getDefaultWpSsoUser' => [
            'application/json',
        ],
        'getWordPressMaintenanceMode' => [
            'application/json',
        ],
        'getWordPressSiteurl' => [
            'application/json',
        ],
        'getWordpressAppVersion' => [
            'application/json',
        ],
        'getWordpressConfig' => [
            'application/json',
        ],
        'getWordpressInstallations' => [
            'application/json',
        ],
        'getWordpressLatestVersion' => [
            'application/json',
        ],
        'getWordpressPlugins' => [
            'application/json',
        ],
        'getWordpressSettings' => [
            'application/json',
        ],
        'getWordpressThemes' => [
            'application/json',
        ],
        'getWordpressUserSsoUrl' => [
            'application/json',
        ],
        'getWordpressUsers' => [
            'application/json',
        ],
        'installWordpressPlugin' => [
            'application/json',
        ],
        'installWordpressTheme' => [
            'application/json',
        ],
        'setDefaultWpSsoUser' => [
            'application/json',
        ],
        'setWordPressMaintenanceMode' => [
            'application/json',
        ],
        'setWordPressSiteurl' => [
            'application/json',
        ],
        'setWordpressConfig' => [
            'application/json',
        ],
        'setWordpressThemeAutoUpdateStatus' => [
            'application/json',
        ],
        'updateWordpressAppVersion' => [
            'application/json',
        ],
        'updateWordpressPluginSettings' => [
            'application/json',
        ],
        'updateWordpressPluginToLatest' => [
            'application/json',
        ],
        'updateWordpressSettings' => [
            'application/json',
        ],
        'updateWordpressTheme' => [
            'application/json',
        ],
        'updateWordpressUser' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation activateWordpressTheme
     *
     * Activate a WordPress theme
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $theme The name of the wordpress theme (not file name!). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['activateWordpressTheme'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function activateWordpressTheme($org_id, $website_id, $app_id, $theme, string $contentType = self::contentTypes['activateWordpressTheme'][0])
    {
        $this->activateWordpressThemeWithHttpInfo($org_id, $website_id, $app_id, $theme, $contentType);
    }

    /**
     * Operation activateWordpressThemeWithHttpInfo
     *
     * Activate a WordPress theme
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $theme The name of the wordpress theme (not file name!). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['activateWordpressTheme'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function activateWordpressThemeWithHttpInfo($org_id, $website_id, $app_id, $theme, string $contentType = self::contentTypes['activateWordpressTheme'][0])
    {
        $request = $this->activateWordpressThemeRequest($org_id, $website_id, $app_id, $theme, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation activateWordpressThemeAsync
     *
     * Activate a WordPress theme
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $theme The name of the wordpress theme (not file name!). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['activateWordpressTheme'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function activateWordpressThemeAsync($org_id, $website_id, $app_id, $theme, string $contentType = self::contentTypes['activateWordpressTheme'][0])
    {
        return $this->activateWordpressThemeAsyncWithHttpInfo($org_id, $website_id, $app_id, $theme, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation activateWordpressThemeAsyncWithHttpInfo
     *
     * Activate a WordPress theme
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $theme The name of the wordpress theme (not file name!). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['activateWordpressTheme'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function activateWordpressThemeAsyncWithHttpInfo($org_id, $website_id, $app_id, $theme, string $contentType = self::contentTypes['activateWordpressTheme'][0])
    {
        $returnType = '';
        $request = $this->activateWordpressThemeRequest($org_id, $website_id, $app_id, $theme, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'activateWordpressTheme'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $theme The name of the wordpress theme (not file name!). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['activateWordpressTheme'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function activateWordpressThemeRequest($org_id, $website_id, $app_id, $theme, string $contentType = self::contentTypes['activateWordpressTheme'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling activateWordpressTheme'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling activateWordpressTheme'
            );
        }

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling activateWordpressTheme'
            );
        }

        // verify the required parameter 'theme' is set
        if ($theme === null || (is_array($theme) && count($theme) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $theme when calling activateWordpressTheme'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/apps/{app_id}/wordpress/themes/{theme}/activate';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }
        // path params
        if ($theme !== null) {
            $resourcePath = str_replace(
                '{' . 'theme' . '}',
                ObjectSerializer::toPathValue($theme),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createWordpressUser
     *
     * Create website WordPress user
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  \OpenAPI\Client\Model\NewWpUser $new_wp_user new_wp_user (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWordpressUser'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createWordpressUser($org_id, $website_id, $app_id, $new_wp_user, string $contentType = self::contentTypes['createWordpressUser'][0])
    {
        $this->createWordpressUserWithHttpInfo($org_id, $website_id, $app_id, $new_wp_user, $contentType);
    }

    /**
     * Operation createWordpressUserWithHttpInfo
     *
     * Create website WordPress user
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  \OpenAPI\Client\Model\NewWpUser $new_wp_user (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWordpressUser'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createWordpressUserWithHttpInfo($org_id, $website_id, $app_id, $new_wp_user, string $contentType = self::contentTypes['createWordpressUser'][0])
    {
        $request = $this->createWordpressUserRequest($org_id, $website_id, $app_id, $new_wp_user, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation createWordpressUserAsync
     *
     * Create website WordPress user
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  \OpenAPI\Client\Model\NewWpUser $new_wp_user (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWordpressUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createWordpressUserAsync($org_id, $website_id, $app_id, $new_wp_user, string $contentType = self::contentTypes['createWordpressUser'][0])
    {
        return $this->createWordpressUserAsyncWithHttpInfo($org_id, $website_id, $app_id, $new_wp_user, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createWordpressUserAsyncWithHttpInfo
     *
     * Create website WordPress user
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  \OpenAPI\Client\Model\NewWpUser $new_wp_user (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWordpressUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createWordpressUserAsyncWithHttpInfo($org_id, $website_id, $app_id, $new_wp_user, string $contentType = self::contentTypes['createWordpressUser'][0])
    {
        $returnType = '';
        $request = $this->createWordpressUserRequest($org_id, $website_id, $app_id, $new_wp_user, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createWordpressUser'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  \OpenAPI\Client\Model\NewWpUser $new_wp_user (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWordpressUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createWordpressUserRequest($org_id, $website_id, $app_id, $new_wp_user, string $contentType = self::contentTypes['createWordpressUser'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling createWordpressUser'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling createWordpressUser'
            );
        }

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling createWordpressUser'
            );
        }

        // verify the required parameter 'new_wp_user' is set
        if ($new_wp_user === null || (is_array($new_wp_user) && count($new_wp_user) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $new_wp_user when calling createWordpressUser'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/apps/{app_id}/wordpress/users';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($new_wp_user)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($new_wp_user));
            } else {
                $httpBody = $new_wp_user;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteWordpressPlugin
     *
     * Delete website WordPress plugin
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $plugin The name of the wordpress plugin (not file name!). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWordpressPlugin'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteWordpressPlugin($org_id, $website_id, $app_id, $plugin, string $contentType = self::contentTypes['deleteWordpressPlugin'][0])
    {
        $this->deleteWordpressPluginWithHttpInfo($org_id, $website_id, $app_id, $plugin, $contentType);
    }

    /**
     * Operation deleteWordpressPluginWithHttpInfo
     *
     * Delete website WordPress plugin
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $plugin The name of the wordpress plugin (not file name!). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWordpressPlugin'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteWordpressPluginWithHttpInfo($org_id, $website_id, $app_id, $plugin, string $contentType = self::contentTypes['deleteWordpressPlugin'][0])
    {
        $request = $this->deleteWordpressPluginRequest($org_id, $website_id, $app_id, $plugin, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteWordpressPluginAsync
     *
     * Delete website WordPress plugin
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $plugin The name of the wordpress plugin (not file name!). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWordpressPlugin'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteWordpressPluginAsync($org_id, $website_id, $app_id, $plugin, string $contentType = self::contentTypes['deleteWordpressPlugin'][0])
    {
        return $this->deleteWordpressPluginAsyncWithHttpInfo($org_id, $website_id, $app_id, $plugin, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteWordpressPluginAsyncWithHttpInfo
     *
     * Delete website WordPress plugin
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $plugin The name of the wordpress plugin (not file name!). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWordpressPlugin'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteWordpressPluginAsyncWithHttpInfo($org_id, $website_id, $app_id, $plugin, string $contentType = self::contentTypes['deleteWordpressPlugin'][0])
    {
        $returnType = '';
        $request = $this->deleteWordpressPluginRequest($org_id, $website_id, $app_id, $plugin, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteWordpressPlugin'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $plugin The name of the wordpress plugin (not file name!). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWordpressPlugin'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteWordpressPluginRequest($org_id, $website_id, $app_id, $plugin, string $contentType = self::contentTypes['deleteWordpressPlugin'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deleteWordpressPlugin'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling deleteWordpressPlugin'
            );
        }

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling deleteWordpressPlugin'
            );
        }

        // verify the required parameter 'plugin' is set
        if ($plugin === null || (is_array($plugin) && count($plugin) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $plugin when calling deleteWordpressPlugin'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/apps/{app_id}/wordpress/plugins/{plugin}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }
        // path params
        if ($plugin !== null) {
            $resourcePath = str_replace(
                '{' . 'plugin' . '}',
                ObjectSerializer::toPathValue($plugin),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteWordpressTheme
     *
     * Delete a WordPress theme
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $theme The name of the wordpress theme (not file name!). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWordpressTheme'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteWordpressTheme($org_id, $website_id, $app_id, $theme, string $contentType = self::contentTypes['deleteWordpressTheme'][0])
    {
        $this->deleteWordpressThemeWithHttpInfo($org_id, $website_id, $app_id, $theme, $contentType);
    }

    /**
     * Operation deleteWordpressThemeWithHttpInfo
     *
     * Delete a WordPress theme
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $theme The name of the wordpress theme (not file name!). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWordpressTheme'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteWordpressThemeWithHttpInfo($org_id, $website_id, $app_id, $theme, string $contentType = self::contentTypes['deleteWordpressTheme'][0])
    {
        $request = $this->deleteWordpressThemeRequest($org_id, $website_id, $app_id, $theme, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteWordpressThemeAsync
     *
     * Delete a WordPress theme
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $theme The name of the wordpress theme (not file name!). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWordpressTheme'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteWordpressThemeAsync($org_id, $website_id, $app_id, $theme, string $contentType = self::contentTypes['deleteWordpressTheme'][0])
    {
        return $this->deleteWordpressThemeAsyncWithHttpInfo($org_id, $website_id, $app_id, $theme, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteWordpressThemeAsyncWithHttpInfo
     *
     * Delete a WordPress theme
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $theme The name of the wordpress theme (not file name!). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWordpressTheme'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteWordpressThemeAsyncWithHttpInfo($org_id, $website_id, $app_id, $theme, string $contentType = self::contentTypes['deleteWordpressTheme'][0])
    {
        $returnType = '';
        $request = $this->deleteWordpressThemeRequest($org_id, $website_id, $app_id, $theme, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteWordpressTheme'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $theme The name of the wordpress theme (not file name!). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWordpressTheme'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteWordpressThemeRequest($org_id, $website_id, $app_id, $theme, string $contentType = self::contentTypes['deleteWordpressTheme'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deleteWordpressTheme'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling deleteWordpressTheme'
            );
        }

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling deleteWordpressTheme'
            );
        }

        // verify the required parameter 'theme' is set
        if ($theme === null || (is_array($theme) && count($theme) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $theme when calling deleteWordpressTheme'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/apps/{app_id}/wordpress/themes/{theme}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }
        // path params
        if ($theme !== null) {
            $resourcePath = str_replace(
                '{' . 'theme' . '}',
                ObjectSerializer::toPathValue($theme),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteWordpressUser
     *
     * Delete WordPress user
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  int $user_id The id of the wordpress user. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWordpressUser'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteWordpressUser($org_id, $website_id, $app_id, $user_id, string $contentType = self::contentTypes['deleteWordpressUser'][0])
    {
        $this->deleteWordpressUserWithHttpInfo($org_id, $website_id, $app_id, $user_id, $contentType);
    }

    /**
     * Operation deleteWordpressUserWithHttpInfo
     *
     * Delete WordPress user
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  int $user_id The id of the wordpress user. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWordpressUser'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteWordpressUserWithHttpInfo($org_id, $website_id, $app_id, $user_id, string $contentType = self::contentTypes['deleteWordpressUser'][0])
    {
        $request = $this->deleteWordpressUserRequest($org_id, $website_id, $app_id, $user_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteWordpressUserAsync
     *
     * Delete WordPress user
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  int $user_id The id of the wordpress user. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWordpressUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteWordpressUserAsync($org_id, $website_id, $app_id, $user_id, string $contentType = self::contentTypes['deleteWordpressUser'][0])
    {
        return $this->deleteWordpressUserAsyncWithHttpInfo($org_id, $website_id, $app_id, $user_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteWordpressUserAsyncWithHttpInfo
     *
     * Delete WordPress user
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  int $user_id The id of the wordpress user. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWordpressUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteWordpressUserAsyncWithHttpInfo($org_id, $website_id, $app_id, $user_id, string $contentType = self::contentTypes['deleteWordpressUser'][0])
    {
        $returnType = '';
        $request = $this->deleteWordpressUserRequest($org_id, $website_id, $app_id, $user_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteWordpressUser'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  int $user_id The id of the wordpress user. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWordpressUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteWordpressUserRequest($org_id, $website_id, $app_id, $user_id, string $contentType = self::contentTypes['deleteWordpressUser'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deleteWordpressUser'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling deleteWordpressUser'
            );
        }

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling deleteWordpressUser'
            );
        }

        // verify the required parameter 'user_id' is set
        if ($user_id === null || (is_array($user_id) && count($user_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_id when calling deleteWordpressUser'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/apps/{app_id}/wordpress/users/{user_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = str_replace(
                '{' . 'user_id' . '}',
                ObjectSerializer::toPathValue($user_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getDefaultWpSsoUser
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDefaultWpSsoUser'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\WpUser
     */
    public function getDefaultWpSsoUser($org_id, $website_id, $app_id, string $contentType = self::contentTypes['getDefaultWpSsoUser'][0])
    {
        list($response) = $this->getDefaultWpSsoUserWithHttpInfo($org_id, $website_id, $app_id, $contentType);
        return $response;
    }

    /**
     * Operation getDefaultWpSsoUserWithHttpInfo
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDefaultWpSsoUser'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\WpUser, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDefaultWpSsoUserWithHttpInfo($org_id, $website_id, $app_id, string $contentType = self::contentTypes['getDefaultWpSsoUser'][0])
    {
        $request = $this->getDefaultWpSsoUserRequest($org_id, $website_id, $app_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\WpUser',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\WpUser',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\WpUser',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getDefaultWpSsoUserAsync
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDefaultWpSsoUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getDefaultWpSsoUserAsync($org_id, $website_id, $app_id, string $contentType = self::contentTypes['getDefaultWpSsoUser'][0])
    {
        return $this->getDefaultWpSsoUserAsyncWithHttpInfo($org_id, $website_id, $app_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getDefaultWpSsoUserAsyncWithHttpInfo
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDefaultWpSsoUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getDefaultWpSsoUserAsyncWithHttpInfo($org_id, $website_id, $app_id, string $contentType = self::contentTypes['getDefaultWpSsoUser'][0])
    {
        $returnType = '\OpenAPI\Client\Model\WpUser';
        $request = $this->getDefaultWpSsoUserRequest($org_id, $website_id, $app_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getDefaultWpSsoUser'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDefaultWpSsoUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getDefaultWpSsoUserRequest($org_id, $website_id, $app_id, string $contentType = self::contentTypes['getDefaultWpSsoUser'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getDefaultWpSsoUser'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling getDefaultWpSsoUser'
            );
        }

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling getDefaultWpSsoUser'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/apps/{app_id}/wordpress/users/default';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWordPressMaintenanceMode
     *
     * Gets the MaintenanceMode for a WordPress installation
     *
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordPressMaintenanceMode'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\MaintenanceModeStatus
     */
    public function getWordPressMaintenanceMode($app_id, string $contentType = self::contentTypes['getWordPressMaintenanceMode'][0])
    {
        list($response) = $this->getWordPressMaintenanceModeWithHttpInfo($app_id, $contentType);
        return $response;
    }

    /**
     * Operation getWordPressMaintenanceModeWithHttpInfo
     *
     * Gets the MaintenanceMode for a WordPress installation
     *
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordPressMaintenanceMode'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\MaintenanceModeStatus, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWordPressMaintenanceModeWithHttpInfo($app_id, string $contentType = self::contentTypes['getWordPressMaintenanceMode'][0])
    {
        $request = $this->getWordPressMaintenanceModeRequest($app_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\MaintenanceModeStatus',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\MaintenanceModeStatus',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\MaintenanceModeStatus',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getWordPressMaintenanceModeAsync
     *
     * Gets the MaintenanceMode for a WordPress installation
     *
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordPressMaintenanceMode'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWordPressMaintenanceModeAsync($app_id, string $contentType = self::contentTypes['getWordPressMaintenanceMode'][0])
    {
        return $this->getWordPressMaintenanceModeAsyncWithHttpInfo($app_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWordPressMaintenanceModeAsyncWithHttpInfo
     *
     * Gets the MaintenanceMode for a WordPress installation
     *
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordPressMaintenanceMode'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWordPressMaintenanceModeAsyncWithHttpInfo($app_id, string $contentType = self::contentTypes['getWordPressMaintenanceMode'][0])
    {
        $returnType = '\OpenAPI\Client\Model\MaintenanceModeStatus';
        $request = $this->getWordPressMaintenanceModeRequest($app_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWordPressMaintenanceMode'
     *
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordPressMaintenanceMode'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWordPressMaintenanceModeRequest($app_id, string $contentType = self::contentTypes['getWordPressMaintenanceMode'][0])
    {

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling getWordPressMaintenanceMode'
            );
        }


        $resourcePath = '/v2/apps/{app_id}/wordpress/maintenance-mode';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWordPressSiteurl
     *
     * Fetches the site URL for a WordPress installation
     *
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordPressSiteurl'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string
     */
    public function getWordPressSiteurl($app_id, string $contentType = self::contentTypes['getWordPressSiteurl'][0])
    {
        list($response) = $this->getWordPressSiteurlWithHttpInfo($app_id, $contentType);
        return $response;
    }

    /**
     * Operation getWordPressSiteurlWithHttpInfo
     *
     * Fetches the site URL for a WordPress installation
     *
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordPressSiteurl'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWordPressSiteurlWithHttpInfo($app_id, string $contentType = self::contentTypes['getWordPressSiteurl'][0])
    {
        $request = $this->getWordPressSiteurlRequest($app_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getWordPressSiteurlAsync
     *
     * Fetches the site URL for a WordPress installation
     *
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordPressSiteurl'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWordPressSiteurlAsync($app_id, string $contentType = self::contentTypes['getWordPressSiteurl'][0])
    {
        return $this->getWordPressSiteurlAsyncWithHttpInfo($app_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWordPressSiteurlAsyncWithHttpInfo
     *
     * Fetches the site URL for a WordPress installation
     *
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordPressSiteurl'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWordPressSiteurlAsyncWithHttpInfo($app_id, string $contentType = self::contentTypes['getWordPressSiteurl'][0])
    {
        $returnType = 'string';
        $request = $this->getWordPressSiteurlRequest($app_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWordPressSiteurl'
     *
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordPressSiteurl'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWordPressSiteurlRequest($app_id, string $contentType = self::contentTypes['getWordPressSiteurl'][0])
    {

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling getWordPressSiteurl'
            );
        }


        $resourcePath = '/v2/apps/{app_id}/wordpress/url';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWordpressAppVersion
     *
     * Get WordPress version
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressAppVersion'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\GetWordpressAppVersion200Response
     */
    public function getWordpressAppVersion($org_id, $website_id, $app_id, string $contentType = self::contentTypes['getWordpressAppVersion'][0])
    {
        list($response) = $this->getWordpressAppVersionWithHttpInfo($org_id, $website_id, $app_id, $contentType);
        return $response;
    }

    /**
     * Operation getWordpressAppVersionWithHttpInfo
     *
     * Get WordPress version
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressAppVersion'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\GetWordpressAppVersion200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWordpressAppVersionWithHttpInfo($org_id, $website_id, $app_id, string $contentType = self::contentTypes['getWordpressAppVersion'][0])
    {
        $request = $this->getWordpressAppVersionRequest($org_id, $website_id, $app_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\GetWordpressAppVersion200Response',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\GetWordpressAppVersion200Response',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\GetWordpressAppVersion200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getWordpressAppVersionAsync
     *
     * Get WordPress version
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressAppVersion'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWordpressAppVersionAsync($org_id, $website_id, $app_id, string $contentType = self::contentTypes['getWordpressAppVersion'][0])
    {
        return $this->getWordpressAppVersionAsyncWithHttpInfo($org_id, $website_id, $app_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWordpressAppVersionAsyncWithHttpInfo
     *
     * Get WordPress version
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressAppVersion'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWordpressAppVersionAsyncWithHttpInfo($org_id, $website_id, $app_id, string $contentType = self::contentTypes['getWordpressAppVersion'][0])
    {
        $returnType = '\OpenAPI\Client\Model\GetWordpressAppVersion200Response';
        $request = $this->getWordpressAppVersionRequest($org_id, $website_id, $app_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWordpressAppVersion'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressAppVersion'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWordpressAppVersionRequest($org_id, $website_id, $app_id, string $contentType = self::contentTypes['getWordpressAppVersion'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getWordpressAppVersion'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling getWordpressAppVersion'
            );
        }

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling getWordpressAppVersion'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/apps/{app_id}/wordpress/version';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWordpressConfig
     *
     * Get the WP config value for a given option
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $wp_option The wordpress config option. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressConfig'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\WordpressConfig
     */
    public function getWordpressConfig($org_id, $website_id, $app_id, $wp_option, string $contentType = self::contentTypes['getWordpressConfig'][0])
    {
        list($response) = $this->getWordpressConfigWithHttpInfo($org_id, $website_id, $app_id, $wp_option, $contentType);
        return $response;
    }

    /**
     * Operation getWordpressConfigWithHttpInfo
     *
     * Get the WP config value for a given option
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $wp_option The wordpress config option. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressConfig'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\WordpressConfig, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWordpressConfigWithHttpInfo($org_id, $website_id, $app_id, $wp_option, string $contentType = self::contentTypes['getWordpressConfig'][0])
    {
        $request = $this->getWordpressConfigRequest($org_id, $website_id, $app_id, $wp_option, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\WordpressConfig',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\WordpressConfig',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\WordpressConfig',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getWordpressConfigAsync
     *
     * Get the WP config value for a given option
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $wp_option The wordpress config option. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressConfig'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWordpressConfigAsync($org_id, $website_id, $app_id, $wp_option, string $contentType = self::contentTypes['getWordpressConfig'][0])
    {
        return $this->getWordpressConfigAsyncWithHttpInfo($org_id, $website_id, $app_id, $wp_option, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWordpressConfigAsyncWithHttpInfo
     *
     * Get the WP config value for a given option
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $wp_option The wordpress config option. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressConfig'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWordpressConfigAsyncWithHttpInfo($org_id, $website_id, $app_id, $wp_option, string $contentType = self::contentTypes['getWordpressConfig'][0])
    {
        $returnType = '\OpenAPI\Client\Model\WordpressConfig';
        $request = $this->getWordpressConfigRequest($org_id, $website_id, $app_id, $wp_option, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWordpressConfig'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $wp_option The wordpress config option. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressConfig'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWordpressConfigRequest($org_id, $website_id, $app_id, $wp_option, string $contentType = self::contentTypes['getWordpressConfig'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getWordpressConfig'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling getWordpressConfig'
            );
        }

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling getWordpressConfig'
            );
        }

        // verify the required parameter 'wp_option' is set
        if ($wp_option === null || (is_array($wp_option) && count($wp_option) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $wp_option when calling getWordpressConfig'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/apps/{app_id}/wordpress/wp-config/{wp_option}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }
        // path params
        if ($wp_option !== null) {
            $resourcePath = str_replace(
                '{' . 'wp_option' . '}',
                ObjectSerializer::toPathValue($wp_option),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWordpressInstallations
     *
     * Trigger discovery of WP installations
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressInstallations'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\WpInstallation[]
     */
    public function getWordpressInstallations($org_id, $website_id, string $contentType = self::contentTypes['getWordpressInstallations'][0])
    {
        list($response) = $this->getWordpressInstallationsWithHttpInfo($org_id, $website_id, $contentType);
        return $response;
    }

    /**
     * Operation getWordpressInstallationsWithHttpInfo
     *
     * Trigger discovery of WP installations
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressInstallations'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\WpInstallation[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getWordpressInstallationsWithHttpInfo($org_id, $website_id, string $contentType = self::contentTypes['getWordpressInstallations'][0])
    {
        $request = $this->getWordpressInstallationsRequest($org_id, $website_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\WpInstallation[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\WpInstallation[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\WpInstallation[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getWordpressInstallationsAsync
     *
     * Trigger discovery of WP installations
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressInstallations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWordpressInstallationsAsync($org_id, $website_id, string $contentType = self::contentTypes['getWordpressInstallations'][0])
    {
        return $this->getWordpressInstallationsAsyncWithHttpInfo($org_id, $website_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWordpressInstallationsAsyncWithHttpInfo
     *
     * Trigger discovery of WP installations
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressInstallations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWordpressInstallationsAsyncWithHttpInfo($org_id, $website_id, string $contentType = self::contentTypes['getWordpressInstallations'][0])
    {
        $returnType = '\OpenAPI\Client\Model\WpInstallation[]';
        $request = $this->getWordpressInstallationsRequest($org_id, $website_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWordpressInstallations'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressInstallations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWordpressInstallationsRequest($org_id, $website_id, string $contentType = self::contentTypes['getWordpressInstallations'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getWordpressInstallations'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling getWordpressInstallations'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/apps/wordpress';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWordpressLatestVersion
     *
     * Get WordPress latest available version
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressLatestVersion'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\WpLatestVersion
     */
    public function getWordpressLatestVersion(string $contentType = self::contentTypes['getWordpressLatestVersion'][0])
    {
        list($response) = $this->getWordpressLatestVersionWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getWordpressLatestVersionWithHttpInfo
     *
     * Get WordPress latest available version
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressLatestVersion'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\WpLatestVersion, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWordpressLatestVersionWithHttpInfo(string $contentType = self::contentTypes['getWordpressLatestVersion'][0])
    {
        $request = $this->getWordpressLatestVersionRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\WpLatestVersion',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\WpLatestVersion',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\WpLatestVersion',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getWordpressLatestVersionAsync
     *
     * Get WordPress latest available version
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressLatestVersion'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWordpressLatestVersionAsync(string $contentType = self::contentTypes['getWordpressLatestVersion'][0])
    {
        return $this->getWordpressLatestVersionAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWordpressLatestVersionAsyncWithHttpInfo
     *
     * Get WordPress latest available version
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressLatestVersion'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWordpressLatestVersionAsyncWithHttpInfo(string $contentType = self::contentTypes['getWordpressLatestVersion'][0])
    {
        $returnType = '\OpenAPI\Client\Model\WpLatestVersion';
        $request = $this->getWordpressLatestVersionRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWordpressLatestVersion'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressLatestVersion'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWordpressLatestVersionRequest(string $contentType = self::contentTypes['getWordpressLatestVersion'][0])
    {


        $resourcePath = '/utils/wordpress/latest';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWordpressPlugins
     *
     * Get website WordPress plugins
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  bool|null $refresh_cache If set to true, it will bypass internal caching. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressPlugins'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\WpPluginsFullListing
     */
    public function getWordpressPlugins($org_id, $website_id, $app_id, $refresh_cache = null, string $contentType = self::contentTypes['getWordpressPlugins'][0])
    {
        list($response) = $this->getWordpressPluginsWithHttpInfo($org_id, $website_id, $app_id, $refresh_cache, $contentType);
        return $response;
    }

    /**
     * Operation getWordpressPluginsWithHttpInfo
     *
     * Get website WordPress plugins
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  bool|null $refresh_cache If set to true, it will bypass internal caching. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressPlugins'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\WpPluginsFullListing, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWordpressPluginsWithHttpInfo($org_id, $website_id, $app_id, $refresh_cache = null, string $contentType = self::contentTypes['getWordpressPlugins'][0])
    {
        $request = $this->getWordpressPluginsRequest($org_id, $website_id, $app_id, $refresh_cache, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\WpPluginsFullListing',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\WpPluginsFullListing',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\WpPluginsFullListing',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getWordpressPluginsAsync
     *
     * Get website WordPress plugins
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  bool|null $refresh_cache If set to true, it will bypass internal caching. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressPlugins'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWordpressPluginsAsync($org_id, $website_id, $app_id, $refresh_cache = null, string $contentType = self::contentTypes['getWordpressPlugins'][0])
    {
        return $this->getWordpressPluginsAsyncWithHttpInfo($org_id, $website_id, $app_id, $refresh_cache, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWordpressPluginsAsyncWithHttpInfo
     *
     * Get website WordPress plugins
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  bool|null $refresh_cache If set to true, it will bypass internal caching. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressPlugins'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWordpressPluginsAsyncWithHttpInfo($org_id, $website_id, $app_id, $refresh_cache = null, string $contentType = self::contentTypes['getWordpressPlugins'][0])
    {
        $returnType = '\OpenAPI\Client\Model\WpPluginsFullListing';
        $request = $this->getWordpressPluginsRequest($org_id, $website_id, $app_id, $refresh_cache, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWordpressPlugins'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  bool|null $refresh_cache If set to true, it will bypass internal caching. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressPlugins'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWordpressPluginsRequest($org_id, $website_id, $app_id, $refresh_cache = null, string $contentType = self::contentTypes['getWordpressPlugins'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getWordpressPlugins'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling getWordpressPlugins'
            );
        }

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling getWordpressPlugins'
            );
        }



        $resourcePath = '/orgs/{org_id}/websites/{website_id}/apps/{app_id}/wordpress/plugins';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $refresh_cache,
            'refreshCache', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWordpressSettings
     *
     * Get Wordpress application settings
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\WpSettings
     */
    public function getWordpressSettings($org_id, $website_id, $app_id, string $contentType = self::contentTypes['getWordpressSettings'][0])
    {
        list($response) = $this->getWordpressSettingsWithHttpInfo($org_id, $website_id, $app_id, $contentType);
        return $response;
    }

    /**
     * Operation getWordpressSettingsWithHttpInfo
     *
     * Get Wordpress application settings
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\WpSettings, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWordpressSettingsWithHttpInfo($org_id, $website_id, $app_id, string $contentType = self::contentTypes['getWordpressSettings'][0])
    {
        $request = $this->getWordpressSettingsRequest($org_id, $website_id, $app_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\WpSettings',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\WpSettings',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\WpSettings',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getWordpressSettingsAsync
     *
     * Get Wordpress application settings
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWordpressSettingsAsync($org_id, $website_id, $app_id, string $contentType = self::contentTypes['getWordpressSettings'][0])
    {
        return $this->getWordpressSettingsAsyncWithHttpInfo($org_id, $website_id, $app_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWordpressSettingsAsyncWithHttpInfo
     *
     * Get Wordpress application settings
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWordpressSettingsAsyncWithHttpInfo($org_id, $website_id, $app_id, string $contentType = self::contentTypes['getWordpressSettings'][0])
    {
        $returnType = '\OpenAPI\Client\Model\WpSettings';
        $request = $this->getWordpressSettingsRequest($org_id, $website_id, $app_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWordpressSettings'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWordpressSettingsRequest($org_id, $website_id, $app_id, string $contentType = self::contentTypes['getWordpressSettings'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getWordpressSettings'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling getWordpressSettings'
            );
        }

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling getWordpressSettings'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/apps/{app_id}/wordpress';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWordpressThemes
     *
     * Get website WordPress themes
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  bool|null $refresh_cache If set to true, it will bypass internal caching. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressThemes'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\WpThemesFullListing
     */
    public function getWordpressThemes($org_id, $website_id, $app_id, $refresh_cache = null, string $contentType = self::contentTypes['getWordpressThemes'][0])
    {
        list($response) = $this->getWordpressThemesWithHttpInfo($org_id, $website_id, $app_id, $refresh_cache, $contentType);
        return $response;
    }

    /**
     * Operation getWordpressThemesWithHttpInfo
     *
     * Get website WordPress themes
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  bool|null $refresh_cache If set to true, it will bypass internal caching. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressThemes'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\WpThemesFullListing, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWordpressThemesWithHttpInfo($org_id, $website_id, $app_id, $refresh_cache = null, string $contentType = self::contentTypes['getWordpressThemes'][0])
    {
        $request = $this->getWordpressThemesRequest($org_id, $website_id, $app_id, $refresh_cache, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\WpThemesFullListing',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\WpThemesFullListing',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\WpThemesFullListing',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getWordpressThemesAsync
     *
     * Get website WordPress themes
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  bool|null $refresh_cache If set to true, it will bypass internal caching. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressThemes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWordpressThemesAsync($org_id, $website_id, $app_id, $refresh_cache = null, string $contentType = self::contentTypes['getWordpressThemes'][0])
    {
        return $this->getWordpressThemesAsyncWithHttpInfo($org_id, $website_id, $app_id, $refresh_cache, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWordpressThemesAsyncWithHttpInfo
     *
     * Get website WordPress themes
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  bool|null $refresh_cache If set to true, it will bypass internal caching. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressThemes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWordpressThemesAsyncWithHttpInfo($org_id, $website_id, $app_id, $refresh_cache = null, string $contentType = self::contentTypes['getWordpressThemes'][0])
    {
        $returnType = '\OpenAPI\Client\Model\WpThemesFullListing';
        $request = $this->getWordpressThemesRequest($org_id, $website_id, $app_id, $refresh_cache, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWordpressThemes'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  bool|null $refresh_cache If set to true, it will bypass internal caching. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressThemes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWordpressThemesRequest($org_id, $website_id, $app_id, $refresh_cache = null, string $contentType = self::contentTypes['getWordpressThemes'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getWordpressThemes'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling getWordpressThemes'
            );
        }

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling getWordpressThemes'
            );
        }



        $resourcePath = '/orgs/{org_id}/websites/{website_id}/apps/{app_id}/wordpress/themes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $refresh_cache,
            'refreshCache', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWordpressUserSsoUrl
     *
     * Get SSO URL for a WP user
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  int $user_id The id of the wordpress user. (required)
     * @param  bool|null $should_redirect If set to true, the endpoint will send a 307 redirect to the SSO URL. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressUserSsoUrl'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string
     */
    public function getWordpressUserSsoUrl($org_id, $website_id, $app_id, $user_id, $should_redirect = null, string $contentType = self::contentTypes['getWordpressUserSsoUrl'][0])
    {
        list($response) = $this->getWordpressUserSsoUrlWithHttpInfo($org_id, $website_id, $app_id, $user_id, $should_redirect, $contentType);
        return $response;
    }

    /**
     * Operation getWordpressUserSsoUrlWithHttpInfo
     *
     * Get SSO URL for a WP user
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  int $user_id The id of the wordpress user. (required)
     * @param  bool|null $should_redirect If set to true, the endpoint will send a 307 redirect to the SSO URL. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressUserSsoUrl'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWordpressUserSsoUrlWithHttpInfo($org_id, $website_id, $app_id, $user_id, $should_redirect = null, string $contentType = self::contentTypes['getWordpressUserSsoUrl'][0])
    {
        $request = $this->getWordpressUserSsoUrlRequest($org_id, $website_id, $app_id, $user_id, $should_redirect, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getWordpressUserSsoUrlAsync
     *
     * Get SSO URL for a WP user
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  int $user_id The id of the wordpress user. (required)
     * @param  bool|null $should_redirect If set to true, the endpoint will send a 307 redirect to the SSO URL. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressUserSsoUrl'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWordpressUserSsoUrlAsync($org_id, $website_id, $app_id, $user_id, $should_redirect = null, string $contentType = self::contentTypes['getWordpressUserSsoUrl'][0])
    {
        return $this->getWordpressUserSsoUrlAsyncWithHttpInfo($org_id, $website_id, $app_id, $user_id, $should_redirect, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWordpressUserSsoUrlAsyncWithHttpInfo
     *
     * Get SSO URL for a WP user
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  int $user_id The id of the wordpress user. (required)
     * @param  bool|null $should_redirect If set to true, the endpoint will send a 307 redirect to the SSO URL. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressUserSsoUrl'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWordpressUserSsoUrlAsyncWithHttpInfo($org_id, $website_id, $app_id, $user_id, $should_redirect = null, string $contentType = self::contentTypes['getWordpressUserSsoUrl'][0])
    {
        $returnType = 'string';
        $request = $this->getWordpressUserSsoUrlRequest($org_id, $website_id, $app_id, $user_id, $should_redirect, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWordpressUserSsoUrl'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  int $user_id The id of the wordpress user. (required)
     * @param  bool|null $should_redirect If set to true, the endpoint will send a 307 redirect to the SSO URL. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressUserSsoUrl'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWordpressUserSsoUrlRequest($org_id, $website_id, $app_id, $user_id, $should_redirect = null, string $contentType = self::contentTypes['getWordpressUserSsoUrl'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getWordpressUserSsoUrl'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling getWordpressUserSsoUrl'
            );
        }

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling getWordpressUserSsoUrl'
            );
        }

        // verify the required parameter 'user_id' is set
        if ($user_id === null || (is_array($user_id) && count($user_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_id when calling getWordpressUserSsoUrl'
            );
        }



        $resourcePath = '/orgs/{org_id}/websites/{website_id}/apps/{app_id}/wordpress/users/{user_id}/sso';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $should_redirect,
            'shouldRedirect', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = str_replace(
                '{' . 'user_id' . '}',
                ObjectSerializer::toPathValue($user_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWordpressUsers
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressUsers'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\WpUsersFullListing
     */
    public function getWordpressUsers($org_id, $website_id, $app_id, string $contentType = self::contentTypes['getWordpressUsers'][0])
    {
        list($response) = $this->getWordpressUsersWithHttpInfo($org_id, $website_id, $app_id, $contentType);
        return $response;
    }

    /**
     * Operation getWordpressUsersWithHttpInfo
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressUsers'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\WpUsersFullListing, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWordpressUsersWithHttpInfo($org_id, $website_id, $app_id, string $contentType = self::contentTypes['getWordpressUsers'][0])
    {
        $request = $this->getWordpressUsersRequest($org_id, $website_id, $app_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\WpUsersFullListing',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\WpUsersFullListing',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\WpUsersFullListing',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getWordpressUsersAsync
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressUsers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWordpressUsersAsync($org_id, $website_id, $app_id, string $contentType = self::contentTypes['getWordpressUsers'][0])
    {
        return $this->getWordpressUsersAsyncWithHttpInfo($org_id, $website_id, $app_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWordpressUsersAsyncWithHttpInfo
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressUsers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWordpressUsersAsyncWithHttpInfo($org_id, $website_id, $app_id, string $contentType = self::contentTypes['getWordpressUsers'][0])
    {
        $returnType = '\OpenAPI\Client\Model\WpUsersFullListing';
        $request = $this->getWordpressUsersRequest($org_id, $website_id, $app_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWordpressUsers'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWordpressUsers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWordpressUsersRequest($org_id, $website_id, $app_id, string $contentType = self::contentTypes['getWordpressUsers'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getWordpressUsers'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling getWordpressUsers'
            );
        }

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling getWordpressUsers'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/apps/{app_id}/wordpress/users';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation installWordpressPlugin
     *
     * Install a plugin
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  \OpenAPI\Client\Model\InstallWpPlugin $install_wp_plugin install_wp_plugin (required)
     * @param  bool|null $refresh_cache If set to true, it will bypass internal caching. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['installWordpressPlugin'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function installWordpressPlugin($org_id, $website_id, $app_id, $install_wp_plugin, $refresh_cache = null, string $contentType = self::contentTypes['installWordpressPlugin'][0])
    {
        $this->installWordpressPluginWithHttpInfo($org_id, $website_id, $app_id, $install_wp_plugin, $refresh_cache, $contentType);
    }

    /**
     * Operation installWordpressPluginWithHttpInfo
     *
     * Install a plugin
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  \OpenAPI\Client\Model\InstallWpPlugin $install_wp_plugin (required)
     * @param  bool|null $refresh_cache If set to true, it will bypass internal caching. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['installWordpressPlugin'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function installWordpressPluginWithHttpInfo($org_id, $website_id, $app_id, $install_wp_plugin, $refresh_cache = null, string $contentType = self::contentTypes['installWordpressPlugin'][0])
    {
        $request = $this->installWordpressPluginRequest($org_id, $website_id, $app_id, $install_wp_plugin, $refresh_cache, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation installWordpressPluginAsync
     *
     * Install a plugin
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  \OpenAPI\Client\Model\InstallWpPlugin $install_wp_plugin (required)
     * @param  bool|null $refresh_cache If set to true, it will bypass internal caching. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['installWordpressPlugin'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function installWordpressPluginAsync($org_id, $website_id, $app_id, $install_wp_plugin, $refresh_cache = null, string $contentType = self::contentTypes['installWordpressPlugin'][0])
    {
        return $this->installWordpressPluginAsyncWithHttpInfo($org_id, $website_id, $app_id, $install_wp_plugin, $refresh_cache, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation installWordpressPluginAsyncWithHttpInfo
     *
     * Install a plugin
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  \OpenAPI\Client\Model\InstallWpPlugin $install_wp_plugin (required)
     * @param  bool|null $refresh_cache If set to true, it will bypass internal caching. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['installWordpressPlugin'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function installWordpressPluginAsyncWithHttpInfo($org_id, $website_id, $app_id, $install_wp_plugin, $refresh_cache = null, string $contentType = self::contentTypes['installWordpressPlugin'][0])
    {
        $returnType = '';
        $request = $this->installWordpressPluginRequest($org_id, $website_id, $app_id, $install_wp_plugin, $refresh_cache, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'installWordpressPlugin'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  \OpenAPI\Client\Model\InstallWpPlugin $install_wp_plugin (required)
     * @param  bool|null $refresh_cache If set to true, it will bypass internal caching. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['installWordpressPlugin'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function installWordpressPluginRequest($org_id, $website_id, $app_id, $install_wp_plugin, $refresh_cache = null, string $contentType = self::contentTypes['installWordpressPlugin'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling installWordpressPlugin'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling installWordpressPlugin'
            );
        }

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling installWordpressPlugin'
            );
        }

        // verify the required parameter 'install_wp_plugin' is set
        if ($install_wp_plugin === null || (is_array($install_wp_plugin) && count($install_wp_plugin) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $install_wp_plugin when calling installWordpressPlugin'
            );
        }



        $resourcePath = '/orgs/{org_id}/websites/{website_id}/apps/{app_id}/wordpress/plugins';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $refresh_cache,
            'refreshCache', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($install_wp_plugin)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($install_wp_plugin));
            } else {
                $httpBody = $install_wp_plugin;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation installWordpressTheme
     *
     * Install a WordPress theme
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  \OpenAPI\Client\Model\InstallWpThemeRequest $install_wp_theme_request install_wp_theme_request (required)
     * @param  bool|null $refresh_cache If set to true, it will bypass internal caching. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['installWordpressTheme'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function installWordpressTheme($org_id, $website_id, $app_id, $install_wp_theme_request, $refresh_cache = null, string $contentType = self::contentTypes['installWordpressTheme'][0])
    {
        $this->installWordpressThemeWithHttpInfo($org_id, $website_id, $app_id, $install_wp_theme_request, $refresh_cache, $contentType);
    }

    /**
     * Operation installWordpressThemeWithHttpInfo
     *
     * Install a WordPress theme
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  \OpenAPI\Client\Model\InstallWpThemeRequest $install_wp_theme_request (required)
     * @param  bool|null $refresh_cache If set to true, it will bypass internal caching. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['installWordpressTheme'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function installWordpressThemeWithHttpInfo($org_id, $website_id, $app_id, $install_wp_theme_request, $refresh_cache = null, string $contentType = self::contentTypes['installWordpressTheme'][0])
    {
        $request = $this->installWordpressThemeRequest($org_id, $website_id, $app_id, $install_wp_theme_request, $refresh_cache, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation installWordpressThemeAsync
     *
     * Install a WordPress theme
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  \OpenAPI\Client\Model\InstallWpThemeRequest $install_wp_theme_request (required)
     * @param  bool|null $refresh_cache If set to true, it will bypass internal caching. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['installWordpressTheme'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function installWordpressThemeAsync($org_id, $website_id, $app_id, $install_wp_theme_request, $refresh_cache = null, string $contentType = self::contentTypes['installWordpressTheme'][0])
    {
        return $this->installWordpressThemeAsyncWithHttpInfo($org_id, $website_id, $app_id, $install_wp_theme_request, $refresh_cache, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation installWordpressThemeAsyncWithHttpInfo
     *
     * Install a WordPress theme
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  \OpenAPI\Client\Model\InstallWpThemeRequest $install_wp_theme_request (required)
     * @param  bool|null $refresh_cache If set to true, it will bypass internal caching. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['installWordpressTheme'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function installWordpressThemeAsyncWithHttpInfo($org_id, $website_id, $app_id, $install_wp_theme_request, $refresh_cache = null, string $contentType = self::contentTypes['installWordpressTheme'][0])
    {
        $returnType = '';
        $request = $this->installWordpressThemeRequest($org_id, $website_id, $app_id, $install_wp_theme_request, $refresh_cache, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'installWordpressTheme'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  \OpenAPI\Client\Model\InstallWpThemeRequest $install_wp_theme_request (required)
     * @param  bool|null $refresh_cache If set to true, it will bypass internal caching. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['installWordpressTheme'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function installWordpressThemeRequest($org_id, $website_id, $app_id, $install_wp_theme_request, $refresh_cache = null, string $contentType = self::contentTypes['installWordpressTheme'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling installWordpressTheme'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling installWordpressTheme'
            );
        }

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling installWordpressTheme'
            );
        }

        // verify the required parameter 'install_wp_theme_request' is set
        if ($install_wp_theme_request === null || (is_array($install_wp_theme_request) && count($install_wp_theme_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $install_wp_theme_request when calling installWordpressTheme'
            );
        }



        $resourcePath = '/orgs/{org_id}/websites/{website_id}/apps/{app_id}/wordpress/themes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $refresh_cache,
            'refreshCache', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($install_wp_theme_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($install_wp_theme_request));
            } else {
                $httpBody = $install_wp_theme_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setDefaultWpSsoUser
     *
     * Set WP user as the default SSO user for that website.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  float $body body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setDefaultWpSsoUser'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setDefaultWpSsoUser($org_id, $website_id, $app_id, $body, string $contentType = self::contentTypes['setDefaultWpSsoUser'][0])
    {
        $this->setDefaultWpSsoUserWithHttpInfo($org_id, $website_id, $app_id, $body, $contentType);
    }

    /**
     * Operation setDefaultWpSsoUserWithHttpInfo
     *
     * Set WP user as the default SSO user for that website.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  float $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setDefaultWpSsoUser'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setDefaultWpSsoUserWithHttpInfo($org_id, $website_id, $app_id, $body, string $contentType = self::contentTypes['setDefaultWpSsoUser'][0])
    {
        $request = $this->setDefaultWpSsoUserRequest($org_id, $website_id, $app_id, $body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation setDefaultWpSsoUserAsync
     *
     * Set WP user as the default SSO user for that website.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  float $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setDefaultWpSsoUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setDefaultWpSsoUserAsync($org_id, $website_id, $app_id, $body, string $contentType = self::contentTypes['setDefaultWpSsoUser'][0])
    {
        return $this->setDefaultWpSsoUserAsyncWithHttpInfo($org_id, $website_id, $app_id, $body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setDefaultWpSsoUserAsyncWithHttpInfo
     *
     * Set WP user as the default SSO user for that website.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  float $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setDefaultWpSsoUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setDefaultWpSsoUserAsyncWithHttpInfo($org_id, $website_id, $app_id, $body, string $contentType = self::contentTypes['setDefaultWpSsoUser'][0])
    {
        $returnType = '';
        $request = $this->setDefaultWpSsoUserRequest($org_id, $website_id, $app_id, $body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setDefaultWpSsoUser'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  float $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setDefaultWpSsoUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setDefaultWpSsoUserRequest($org_id, $website_id, $app_id, $body, string $contentType = self::contentTypes['setDefaultWpSsoUser'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling setDefaultWpSsoUser'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling setDefaultWpSsoUser'
            );
        }

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling setDefaultWpSsoUser'
            );
        }

        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling setDefaultWpSsoUser'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/apps/{app_id}/wordpress/users/default';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setWordPressMaintenanceMode
     *
     * Sets the MaintenanceMode for a WordPress installation
     *
     * @param  string $app_id The id of the app. (required)
     * @param  string $body body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setWordPressMaintenanceMode'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setWordPressMaintenanceMode($app_id, $body, string $contentType = self::contentTypes['setWordPressMaintenanceMode'][0])
    {
        $this->setWordPressMaintenanceModeWithHttpInfo($app_id, $body, $contentType);
    }

    /**
     * Operation setWordPressMaintenanceModeWithHttpInfo
     *
     * Sets the MaintenanceMode for a WordPress installation
     *
     * @param  string $app_id The id of the app. (required)
     * @param  string $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setWordPressMaintenanceMode'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setWordPressMaintenanceModeWithHttpInfo($app_id, $body, string $contentType = self::contentTypes['setWordPressMaintenanceMode'][0])
    {
        $request = $this->setWordPressMaintenanceModeRequest($app_id, $body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation setWordPressMaintenanceModeAsync
     *
     * Sets the MaintenanceMode for a WordPress installation
     *
     * @param  string $app_id The id of the app. (required)
     * @param  string $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setWordPressMaintenanceMode'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setWordPressMaintenanceModeAsync($app_id, $body, string $contentType = self::contentTypes['setWordPressMaintenanceMode'][0])
    {
        return $this->setWordPressMaintenanceModeAsyncWithHttpInfo($app_id, $body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setWordPressMaintenanceModeAsyncWithHttpInfo
     *
     * Sets the MaintenanceMode for a WordPress installation
     *
     * @param  string $app_id The id of the app. (required)
     * @param  string $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setWordPressMaintenanceMode'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setWordPressMaintenanceModeAsyncWithHttpInfo($app_id, $body, string $contentType = self::contentTypes['setWordPressMaintenanceMode'][0])
    {
        $returnType = '';
        $request = $this->setWordPressMaintenanceModeRequest($app_id, $body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setWordPressMaintenanceMode'
     *
     * @param  string $app_id The id of the app. (required)
     * @param  string $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setWordPressMaintenanceMode'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setWordPressMaintenanceModeRequest($app_id, $body, string $contentType = self::contentTypes['setWordPressMaintenanceMode'][0])
    {

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling setWordPressMaintenanceMode'
            );
        }

        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling setWordPressMaintenanceMode'
            );
        }


        $resourcePath = '/v2/apps/{app_id}/wordpress/maintenance-mode';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setWordPressSiteurl
     *
     * Sets the site URL for a WordPress installation
     *
     * @param  string $app_id The id of the app. (required)
     * @param  string $body body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setWordPressSiteurl'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setWordPressSiteurl($app_id, $body, string $contentType = self::contentTypes['setWordPressSiteurl'][0])
    {
        $this->setWordPressSiteurlWithHttpInfo($app_id, $body, $contentType);
    }

    /**
     * Operation setWordPressSiteurlWithHttpInfo
     *
     * Sets the site URL for a WordPress installation
     *
     * @param  string $app_id The id of the app. (required)
     * @param  string $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setWordPressSiteurl'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setWordPressSiteurlWithHttpInfo($app_id, $body, string $contentType = self::contentTypes['setWordPressSiteurl'][0])
    {
        $request = $this->setWordPressSiteurlRequest($app_id, $body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation setWordPressSiteurlAsync
     *
     * Sets the site URL for a WordPress installation
     *
     * @param  string $app_id The id of the app. (required)
     * @param  string $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setWordPressSiteurl'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setWordPressSiteurlAsync($app_id, $body, string $contentType = self::contentTypes['setWordPressSiteurl'][0])
    {
        return $this->setWordPressSiteurlAsyncWithHttpInfo($app_id, $body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setWordPressSiteurlAsyncWithHttpInfo
     *
     * Sets the site URL for a WordPress installation
     *
     * @param  string $app_id The id of the app. (required)
     * @param  string $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setWordPressSiteurl'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setWordPressSiteurlAsyncWithHttpInfo($app_id, $body, string $contentType = self::contentTypes['setWordPressSiteurl'][0])
    {
        $returnType = '';
        $request = $this->setWordPressSiteurlRequest($app_id, $body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setWordPressSiteurl'
     *
     * @param  string $app_id The id of the app. (required)
     * @param  string $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setWordPressSiteurl'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setWordPressSiteurlRequest($app_id, $body, string $contentType = self::contentTypes['setWordPressSiteurl'][0])
    {

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling setWordPressSiteurl'
            );
        }

        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling setWordPressSiteurl'
            );
        }


        $resourcePath = '/v2/apps/{app_id}/wordpress/url';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setWordpressConfig
     *
     * Set a single value of a wp-config.php entry.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  \OpenAPI\Client\Model\WordpressConfig $wordpress_config wordpress_config (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setWordpressConfig'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setWordpressConfig($org_id, $website_id, $app_id, $wordpress_config, string $contentType = self::contentTypes['setWordpressConfig'][0])
    {
        $this->setWordpressConfigWithHttpInfo($org_id, $website_id, $app_id, $wordpress_config, $contentType);
    }

    /**
     * Operation setWordpressConfigWithHttpInfo
     *
     * Set a single value of a wp-config.php entry.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  \OpenAPI\Client\Model\WordpressConfig $wordpress_config (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setWordpressConfig'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setWordpressConfigWithHttpInfo($org_id, $website_id, $app_id, $wordpress_config, string $contentType = self::contentTypes['setWordpressConfig'][0])
    {
        $request = $this->setWordpressConfigRequest($org_id, $website_id, $app_id, $wordpress_config, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation setWordpressConfigAsync
     *
     * Set a single value of a wp-config.php entry.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  \OpenAPI\Client\Model\WordpressConfig $wordpress_config (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setWordpressConfig'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setWordpressConfigAsync($org_id, $website_id, $app_id, $wordpress_config, string $contentType = self::contentTypes['setWordpressConfig'][0])
    {
        return $this->setWordpressConfigAsyncWithHttpInfo($org_id, $website_id, $app_id, $wordpress_config, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setWordpressConfigAsyncWithHttpInfo
     *
     * Set a single value of a wp-config.php entry.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  \OpenAPI\Client\Model\WordpressConfig $wordpress_config (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setWordpressConfig'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setWordpressConfigAsyncWithHttpInfo($org_id, $website_id, $app_id, $wordpress_config, string $contentType = self::contentTypes['setWordpressConfig'][0])
    {
        $returnType = '';
        $request = $this->setWordpressConfigRequest($org_id, $website_id, $app_id, $wordpress_config, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setWordpressConfig'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  \OpenAPI\Client\Model\WordpressConfig $wordpress_config (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setWordpressConfig'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setWordpressConfigRequest($org_id, $website_id, $app_id, $wordpress_config, string $contentType = self::contentTypes['setWordpressConfig'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling setWordpressConfig'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling setWordpressConfig'
            );
        }

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling setWordpressConfig'
            );
        }

        // verify the required parameter 'wordpress_config' is set
        if ($wordpress_config === null || (is_array($wordpress_config) && count($wordpress_config) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $wordpress_config when calling setWordpressConfig'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/apps/{app_id}/wordpress/wp-config';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($wordpress_config)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($wordpress_config));
            } else {
                $httpBody = $wordpress_config;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setWordpressThemeAutoUpdateStatus
     *
     * Set WordPress theme auto-update status
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $theme The name of the wordpress theme (not file name!). (required)
     * @param  bool $body body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setWordpressThemeAutoUpdateStatus'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setWordpressThemeAutoUpdateStatus($org_id, $website_id, $app_id, $theme, $body, string $contentType = self::contentTypes['setWordpressThemeAutoUpdateStatus'][0])
    {
        $this->setWordpressThemeAutoUpdateStatusWithHttpInfo($org_id, $website_id, $app_id, $theme, $body, $contentType);
    }

    /**
     * Operation setWordpressThemeAutoUpdateStatusWithHttpInfo
     *
     * Set WordPress theme auto-update status
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $theme The name of the wordpress theme (not file name!). (required)
     * @param  bool $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setWordpressThemeAutoUpdateStatus'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setWordpressThemeAutoUpdateStatusWithHttpInfo($org_id, $website_id, $app_id, $theme, $body, string $contentType = self::contentTypes['setWordpressThemeAutoUpdateStatus'][0])
    {
        $request = $this->setWordpressThemeAutoUpdateStatusRequest($org_id, $website_id, $app_id, $theme, $body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation setWordpressThemeAutoUpdateStatusAsync
     *
     * Set WordPress theme auto-update status
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $theme The name of the wordpress theme (not file name!). (required)
     * @param  bool $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setWordpressThemeAutoUpdateStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setWordpressThemeAutoUpdateStatusAsync($org_id, $website_id, $app_id, $theme, $body, string $contentType = self::contentTypes['setWordpressThemeAutoUpdateStatus'][0])
    {
        return $this->setWordpressThemeAutoUpdateStatusAsyncWithHttpInfo($org_id, $website_id, $app_id, $theme, $body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setWordpressThemeAutoUpdateStatusAsyncWithHttpInfo
     *
     * Set WordPress theme auto-update status
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $theme The name of the wordpress theme (not file name!). (required)
     * @param  bool $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setWordpressThemeAutoUpdateStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setWordpressThemeAutoUpdateStatusAsyncWithHttpInfo($org_id, $website_id, $app_id, $theme, $body, string $contentType = self::contentTypes['setWordpressThemeAutoUpdateStatus'][0])
    {
        $returnType = '';
        $request = $this->setWordpressThemeAutoUpdateStatusRequest($org_id, $website_id, $app_id, $theme, $body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setWordpressThemeAutoUpdateStatus'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $theme The name of the wordpress theme (not file name!). (required)
     * @param  bool $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setWordpressThemeAutoUpdateStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setWordpressThemeAutoUpdateStatusRequest($org_id, $website_id, $app_id, $theme, $body, string $contentType = self::contentTypes['setWordpressThemeAutoUpdateStatus'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling setWordpressThemeAutoUpdateStatus'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling setWordpressThemeAutoUpdateStatus'
            );
        }

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling setWordpressThemeAutoUpdateStatus'
            );
        }

        // verify the required parameter 'theme' is set
        if ($theme === null || (is_array($theme) && count($theme) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $theme when calling setWordpressThemeAutoUpdateStatus'
            );
        }

        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling setWordpressThemeAutoUpdateStatus'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/apps/{app_id}/wordpress/themes/{theme}/auto_update';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }
        // path params
        if ($theme !== null) {
            $resourcePath = str_replace(
                '{' . 'theme' . '}',
                ObjectSerializer::toPathValue($theme),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateWordpressAppVersion
     *
     * Update website WP app to specific version or latest
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWordpressAppVersion'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateWordpressAppVersion($org_id, $website_id, $app_id, string $contentType = self::contentTypes['updateWordpressAppVersion'][0])
    {
        $this->updateWordpressAppVersionWithHttpInfo($org_id, $website_id, $app_id, $contentType);
    }

    /**
     * Operation updateWordpressAppVersionWithHttpInfo
     *
     * Update website WP app to specific version or latest
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWordpressAppVersion'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateWordpressAppVersionWithHttpInfo($org_id, $website_id, $app_id, string $contentType = self::contentTypes['updateWordpressAppVersion'][0])
    {
        $request = $this->updateWordpressAppVersionRequest($org_id, $website_id, $app_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateWordpressAppVersionAsync
     *
     * Update website WP app to specific version or latest
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWordpressAppVersion'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateWordpressAppVersionAsync($org_id, $website_id, $app_id, string $contentType = self::contentTypes['updateWordpressAppVersion'][0])
    {
        return $this->updateWordpressAppVersionAsyncWithHttpInfo($org_id, $website_id, $app_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateWordpressAppVersionAsyncWithHttpInfo
     *
     * Update website WP app to specific version or latest
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWordpressAppVersion'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateWordpressAppVersionAsyncWithHttpInfo($org_id, $website_id, $app_id, string $contentType = self::contentTypes['updateWordpressAppVersion'][0])
    {
        $returnType = '';
        $request = $this->updateWordpressAppVersionRequest($org_id, $website_id, $app_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateWordpressAppVersion'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWordpressAppVersion'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateWordpressAppVersionRequest($org_id, $website_id, $app_id, string $contentType = self::contentTypes['updateWordpressAppVersion'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling updateWordpressAppVersion'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling updateWordpressAppVersion'
            );
        }

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling updateWordpressAppVersion'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/apps/{app_id}/wordpress/version';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateWordpressPluginSettings
     *
     * Updates website WordPress plugin settings
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $plugin The name of the wordpress plugin (not file name!). (required)
     * @param  \OpenAPI\Client\Model\UpdateWpPlugin $update_wp_plugin update_wp_plugin (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWordpressPluginSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateWordpressPluginSettings($org_id, $website_id, $app_id, $plugin, $update_wp_plugin, string $contentType = self::contentTypes['updateWordpressPluginSettings'][0])
    {
        $this->updateWordpressPluginSettingsWithHttpInfo($org_id, $website_id, $app_id, $plugin, $update_wp_plugin, $contentType);
    }

    /**
     * Operation updateWordpressPluginSettingsWithHttpInfo
     *
     * Updates website WordPress plugin settings
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $plugin The name of the wordpress plugin (not file name!). (required)
     * @param  \OpenAPI\Client\Model\UpdateWpPlugin $update_wp_plugin (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWordpressPluginSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateWordpressPluginSettingsWithHttpInfo($org_id, $website_id, $app_id, $plugin, $update_wp_plugin, string $contentType = self::contentTypes['updateWordpressPluginSettings'][0])
    {
        $request = $this->updateWordpressPluginSettingsRequest($org_id, $website_id, $app_id, $plugin, $update_wp_plugin, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateWordpressPluginSettingsAsync
     *
     * Updates website WordPress plugin settings
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $plugin The name of the wordpress plugin (not file name!). (required)
     * @param  \OpenAPI\Client\Model\UpdateWpPlugin $update_wp_plugin (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWordpressPluginSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateWordpressPluginSettingsAsync($org_id, $website_id, $app_id, $plugin, $update_wp_plugin, string $contentType = self::contentTypes['updateWordpressPluginSettings'][0])
    {
        return $this->updateWordpressPluginSettingsAsyncWithHttpInfo($org_id, $website_id, $app_id, $plugin, $update_wp_plugin, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateWordpressPluginSettingsAsyncWithHttpInfo
     *
     * Updates website WordPress plugin settings
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $plugin The name of the wordpress plugin (not file name!). (required)
     * @param  \OpenAPI\Client\Model\UpdateWpPlugin $update_wp_plugin (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWordpressPluginSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateWordpressPluginSettingsAsyncWithHttpInfo($org_id, $website_id, $app_id, $plugin, $update_wp_plugin, string $contentType = self::contentTypes['updateWordpressPluginSettings'][0])
    {
        $returnType = '';
        $request = $this->updateWordpressPluginSettingsRequest($org_id, $website_id, $app_id, $plugin, $update_wp_plugin, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateWordpressPluginSettings'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $plugin The name of the wordpress plugin (not file name!). (required)
     * @param  \OpenAPI\Client\Model\UpdateWpPlugin $update_wp_plugin (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWordpressPluginSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateWordpressPluginSettingsRequest($org_id, $website_id, $app_id, $plugin, $update_wp_plugin, string $contentType = self::contentTypes['updateWordpressPluginSettings'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling updateWordpressPluginSettings'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling updateWordpressPluginSettings'
            );
        }

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling updateWordpressPluginSettings'
            );
        }

        // verify the required parameter 'plugin' is set
        if ($plugin === null || (is_array($plugin) && count($plugin) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $plugin when calling updateWordpressPluginSettings'
            );
        }

        // verify the required parameter 'update_wp_plugin' is set
        if ($update_wp_plugin === null || (is_array($update_wp_plugin) && count($update_wp_plugin) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $update_wp_plugin when calling updateWordpressPluginSettings'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/apps/{app_id}/wordpress/plugins/{plugin}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }
        // path params
        if ($plugin !== null) {
            $resourcePath = str_replace(
                '{' . 'plugin' . '}',
                ObjectSerializer::toPathValue($plugin),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($update_wp_plugin)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($update_wp_plugin));
            } else {
                $httpBody = $update_wp_plugin;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateWordpressPluginToLatest
     *
     * Updates website WordPress plugin to latest version
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $plugin The name of the wordpress plugin (not file name!). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWordpressPluginToLatest'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateWordpressPluginToLatest($org_id, $website_id, $app_id, $plugin, string $contentType = self::contentTypes['updateWordpressPluginToLatest'][0])
    {
        $this->updateWordpressPluginToLatestWithHttpInfo($org_id, $website_id, $app_id, $plugin, $contentType);
    }

    /**
     * Operation updateWordpressPluginToLatestWithHttpInfo
     *
     * Updates website WordPress plugin to latest version
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $plugin The name of the wordpress plugin (not file name!). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWordpressPluginToLatest'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateWordpressPluginToLatestWithHttpInfo($org_id, $website_id, $app_id, $plugin, string $contentType = self::contentTypes['updateWordpressPluginToLatest'][0])
    {
        $request = $this->updateWordpressPluginToLatestRequest($org_id, $website_id, $app_id, $plugin, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateWordpressPluginToLatestAsync
     *
     * Updates website WordPress plugin to latest version
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $plugin The name of the wordpress plugin (not file name!). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWordpressPluginToLatest'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateWordpressPluginToLatestAsync($org_id, $website_id, $app_id, $plugin, string $contentType = self::contentTypes['updateWordpressPluginToLatest'][0])
    {
        return $this->updateWordpressPluginToLatestAsyncWithHttpInfo($org_id, $website_id, $app_id, $plugin, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateWordpressPluginToLatestAsyncWithHttpInfo
     *
     * Updates website WordPress plugin to latest version
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $plugin The name of the wordpress plugin (not file name!). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWordpressPluginToLatest'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateWordpressPluginToLatestAsyncWithHttpInfo($org_id, $website_id, $app_id, $plugin, string $contentType = self::contentTypes['updateWordpressPluginToLatest'][0])
    {
        $returnType = '';
        $request = $this->updateWordpressPluginToLatestRequest($org_id, $website_id, $app_id, $plugin, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateWordpressPluginToLatest'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $plugin The name of the wordpress plugin (not file name!). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWordpressPluginToLatest'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateWordpressPluginToLatestRequest($org_id, $website_id, $app_id, $plugin, string $contentType = self::contentTypes['updateWordpressPluginToLatest'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling updateWordpressPluginToLatest'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling updateWordpressPluginToLatest'
            );
        }

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling updateWordpressPluginToLatest'
            );
        }

        // verify the required parameter 'plugin' is set
        if ($plugin === null || (is_array($plugin) && count($plugin) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $plugin when calling updateWordpressPluginToLatest'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/apps/{app_id}/wordpress/plugins/{plugin}/version';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }
        // path params
        if ($plugin !== null) {
            $resourcePath = str_replace(
                '{' . 'plugin' . '}',
                ObjectSerializer::toPathValue($plugin),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateWordpressSettings
     *
     * Update Wordpress app settings
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  \OpenAPI\Client\Model\UpdateWpSettings $update_wp_settings update_wp_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWordpressSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateWordpressSettings($org_id, $website_id, $app_id, $update_wp_settings, string $contentType = self::contentTypes['updateWordpressSettings'][0])
    {
        $this->updateWordpressSettingsWithHttpInfo($org_id, $website_id, $app_id, $update_wp_settings, $contentType);
    }

    /**
     * Operation updateWordpressSettingsWithHttpInfo
     *
     * Update Wordpress app settings
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  \OpenAPI\Client\Model\UpdateWpSettings $update_wp_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWordpressSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateWordpressSettingsWithHttpInfo($org_id, $website_id, $app_id, $update_wp_settings, string $contentType = self::contentTypes['updateWordpressSettings'][0])
    {
        $request = $this->updateWordpressSettingsRequest($org_id, $website_id, $app_id, $update_wp_settings, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateWordpressSettingsAsync
     *
     * Update Wordpress app settings
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  \OpenAPI\Client\Model\UpdateWpSettings $update_wp_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWordpressSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateWordpressSettingsAsync($org_id, $website_id, $app_id, $update_wp_settings, string $contentType = self::contentTypes['updateWordpressSettings'][0])
    {
        return $this->updateWordpressSettingsAsyncWithHttpInfo($org_id, $website_id, $app_id, $update_wp_settings, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateWordpressSettingsAsyncWithHttpInfo
     *
     * Update Wordpress app settings
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  \OpenAPI\Client\Model\UpdateWpSettings $update_wp_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWordpressSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateWordpressSettingsAsyncWithHttpInfo($org_id, $website_id, $app_id, $update_wp_settings, string $contentType = self::contentTypes['updateWordpressSettings'][0])
    {
        $returnType = '';
        $request = $this->updateWordpressSettingsRequest($org_id, $website_id, $app_id, $update_wp_settings, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateWordpressSettings'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  \OpenAPI\Client\Model\UpdateWpSettings $update_wp_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWordpressSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateWordpressSettingsRequest($org_id, $website_id, $app_id, $update_wp_settings, string $contentType = self::contentTypes['updateWordpressSettings'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling updateWordpressSettings'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling updateWordpressSettings'
            );
        }

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling updateWordpressSettings'
            );
        }

        // verify the required parameter 'update_wp_settings' is set
        if ($update_wp_settings === null || (is_array($update_wp_settings) && count($update_wp_settings) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $update_wp_settings when calling updateWordpressSettings'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/apps/{app_id}/wordpress';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($update_wp_settings)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($update_wp_settings));
            } else {
                $httpBody = $update_wp_settings;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateWordpressTheme
     *
     * Update a WordPress theme
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $theme The name of the wordpress theme (not file name!). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWordpressTheme'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateWordpressTheme($org_id, $website_id, $app_id, $theme, string $contentType = self::contentTypes['updateWordpressTheme'][0])
    {
        $this->updateWordpressThemeWithHttpInfo($org_id, $website_id, $app_id, $theme, $contentType);
    }

    /**
     * Operation updateWordpressThemeWithHttpInfo
     *
     * Update a WordPress theme
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $theme The name of the wordpress theme (not file name!). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWordpressTheme'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateWordpressThemeWithHttpInfo($org_id, $website_id, $app_id, $theme, string $contentType = self::contentTypes['updateWordpressTheme'][0])
    {
        $request = $this->updateWordpressThemeRequest($org_id, $website_id, $app_id, $theme, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateWordpressThemeAsync
     *
     * Update a WordPress theme
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $theme The name of the wordpress theme (not file name!). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWordpressTheme'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateWordpressThemeAsync($org_id, $website_id, $app_id, $theme, string $contentType = self::contentTypes['updateWordpressTheme'][0])
    {
        return $this->updateWordpressThemeAsyncWithHttpInfo($org_id, $website_id, $app_id, $theme, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateWordpressThemeAsyncWithHttpInfo
     *
     * Update a WordPress theme
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $theme The name of the wordpress theme (not file name!). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWordpressTheme'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateWordpressThemeAsyncWithHttpInfo($org_id, $website_id, $app_id, $theme, string $contentType = self::contentTypes['updateWordpressTheme'][0])
    {
        $returnType = '';
        $request = $this->updateWordpressThemeRequest($org_id, $website_id, $app_id, $theme, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateWordpressTheme'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  string $theme The name of the wordpress theme (not file name!). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWordpressTheme'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateWordpressThemeRequest($org_id, $website_id, $app_id, $theme, string $contentType = self::contentTypes['updateWordpressTheme'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling updateWordpressTheme'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling updateWordpressTheme'
            );
        }

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling updateWordpressTheme'
            );
        }

        // verify the required parameter 'theme' is set
        if ($theme === null || (is_array($theme) && count($theme) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $theme when calling updateWordpressTheme'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/apps/{app_id}/wordpress/themes/{theme}/update';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }
        // path params
        if ($theme !== null) {
            $resourcePath = str_replace(
                '{' . 'theme' . '}',
                ObjectSerializer::toPathValue($theme),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateWordpressUser
     *
     * Update WordPress user
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  int $user_id The id of the wordpress user. (required)
     * @param  \OpenAPI\Client\Model\UpdateWpUser $update_wp_user update_wp_user (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWordpressUser'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateWordpressUser($org_id, $website_id, $app_id, $user_id, $update_wp_user, string $contentType = self::contentTypes['updateWordpressUser'][0])
    {
        $this->updateWordpressUserWithHttpInfo($org_id, $website_id, $app_id, $user_id, $update_wp_user, $contentType);
    }

    /**
     * Operation updateWordpressUserWithHttpInfo
     *
     * Update WordPress user
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  int $user_id The id of the wordpress user. (required)
     * @param  \OpenAPI\Client\Model\UpdateWpUser $update_wp_user (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWordpressUser'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateWordpressUserWithHttpInfo($org_id, $website_id, $app_id, $user_id, $update_wp_user, string $contentType = self::contentTypes['updateWordpressUser'][0])
    {
        $request = $this->updateWordpressUserRequest($org_id, $website_id, $app_id, $user_id, $update_wp_user, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateWordpressUserAsync
     *
     * Update WordPress user
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  int $user_id The id of the wordpress user. (required)
     * @param  \OpenAPI\Client\Model\UpdateWpUser $update_wp_user (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWordpressUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateWordpressUserAsync($org_id, $website_id, $app_id, $user_id, $update_wp_user, string $contentType = self::contentTypes['updateWordpressUser'][0])
    {
        return $this->updateWordpressUserAsyncWithHttpInfo($org_id, $website_id, $app_id, $user_id, $update_wp_user, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateWordpressUserAsyncWithHttpInfo
     *
     * Update WordPress user
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  int $user_id The id of the wordpress user. (required)
     * @param  \OpenAPI\Client\Model\UpdateWpUser $update_wp_user (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWordpressUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateWordpressUserAsyncWithHttpInfo($org_id, $website_id, $app_id, $user_id, $update_wp_user, string $contentType = self::contentTypes['updateWordpressUser'][0])
    {
        $returnType = '';
        $request = $this->updateWordpressUserRequest($org_id, $website_id, $app_id, $user_id, $update_wp_user, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateWordpressUser'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $app_id The id of the app. (required)
     * @param  int $user_id The id of the wordpress user. (required)
     * @param  \OpenAPI\Client\Model\UpdateWpUser $update_wp_user (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWordpressUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateWordpressUserRequest($org_id, $website_id, $app_id, $user_id, $update_wp_user, string $contentType = self::contentTypes['updateWordpressUser'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling updateWordpressUser'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling updateWordpressUser'
            );
        }

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling updateWordpressUser'
            );
        }

        // verify the required parameter 'user_id' is set
        if ($user_id === null || (is_array($user_id) && count($user_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_id when calling updateWordpressUser'
            );
        }

        // verify the required parameter 'update_wp_user' is set
        if ($update_wp_user === null || (is_array($update_wp_user) && count($update_wp_user) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $update_wp_user when calling updateWordpressUser'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/apps/{app_id}/wordpress/users/{user_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'app_id' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = str_replace(
                '{' . 'user_id' . '}',
                ObjectSerializer::toPathValue($user_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($update_wp_user)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($update_wp_user));
            } else {
                $httpBody = $update_wp_user;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        if ($this->config->getCertFile()) {
            $options[RequestOptions::CERT] = $this->config->getCertFile();
        }

        if ($this->config->getKeyFile()) {
            $options[RequestOptions::SSL_KEY] = $this->config->getKeyFile();
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
