<?php
/**
 * PersistentApp
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * orchd
 *
 * orchd API docs
 *
 * The version of the OpenAPI document: 12.13.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.17.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Model;

use \ArrayAccess;
use \OpenAPI\Client\ObjectSerializer;

/**
 * PersistentApp Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PersistentApp implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PersistentApp';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'proxy_details' => '\OpenAPI\Client\Model\PersistentAppProxyDetails',
        'start_mode' => '\OpenAPI\Client\Model\PersistentAppStartMode',
        'command' => 'string',
        'working_directory' => 'string',
        'node_version' => '\OpenAPI\Client\Model\NodeVersion'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'proxy_details' => null,
        'start_mode' => null,
        'command' => null,
        'working_directory' => null,
        'node_version' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'proxy_details' => false,
        'start_mode' => false,
        'command' => false,
        'working_directory' => false,
        'node_version' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'proxy_details' => 'proxyDetails',
        'start_mode' => 'startMode',
        'command' => 'command',
        'working_directory' => 'workingDirectory',
        'node_version' => 'nodeVersion'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'proxy_details' => 'setProxyDetails',
        'start_mode' => 'setStartMode',
        'command' => 'setCommand',
        'working_directory' => 'setWorkingDirectory',
        'node_version' => 'setNodeVersion'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'proxy_details' => 'getProxyDetails',
        'start_mode' => 'getStartMode',
        'command' => 'getCommand',
        'working_directory' => 'getWorkingDirectory',
        'node_version' => 'getNodeVersion'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('proxy_details', $data ?? [], null);
        $this->setIfExists('start_mode', $data ?? [], null);
        $this->setIfExists('command', $data ?? [], null);
        $this->setIfExists('working_directory', $data ?? [], null);
        $this->setIfExists('node_version', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['start_mode'] === null) {
            $invalidProperties[] = "'start_mode' can't be null";
        }
        if ($this->container['command'] === null) {
            $invalidProperties[] = "'command' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets proxy_details
     *
     * @return \OpenAPI\Client\Model\PersistentAppProxyDetails|null
     */
    public function getProxyDetails()
    {
        return $this->container['proxy_details'];
    }

    /**
     * Sets proxy_details
     *
     * @param \OpenAPI\Client\Model\PersistentAppProxyDetails|null $proxy_details proxy_details
     *
     * @return self
     */
    public function setProxyDetails($proxy_details)
    {
        if (is_null($proxy_details)) {
            throw new \InvalidArgumentException('non-nullable proxy_details cannot be null');
        }
        $this->container['proxy_details'] = $proxy_details;

        return $this;
    }

    /**
     * Gets start_mode
     *
     * @return \OpenAPI\Client\Model\PersistentAppStartMode
     */
    public function getStartMode()
    {
        return $this->container['start_mode'];
    }

    /**
     * Sets start_mode
     *
     * @param \OpenAPI\Client\Model\PersistentAppStartMode $start_mode start_mode
     *
     * @return self
     */
    public function setStartMode($start_mode)
    {
        if (is_null($start_mode)) {
            throw new \InvalidArgumentException('non-nullable start_mode cannot be null');
        }
        $this->container['start_mode'] = $start_mode;

        return $this;
    }

    /**
     * Gets command
     *
     * @return string
     */
    public function getCommand()
    {
        return $this->container['command'];
    }

    /**
     * Sets command
     *
     * @param string $command command
     *
     * @return self
     */
    public function setCommand($command)
    {
        if (is_null($command)) {
            throw new \InvalidArgumentException('non-nullable command cannot be null');
        }
        $this->container['command'] = $command;

        return $this;
    }

    /**
     * Gets working_directory
     *
     * @return string|null
     */
    public function getWorkingDirectory()
    {
        return $this->container['working_directory'];
    }

    /**
     * Sets working_directory
     *
     * @param string|null $working_directory working_directory
     *
     * @return self
     */
    public function setWorkingDirectory($working_directory)
    {
        if (is_null($working_directory)) {
            throw new \InvalidArgumentException('non-nullable working_directory cannot be null');
        }
        $this->container['working_directory'] = $working_directory;

        return $this;
    }

    /**
     * Gets node_version
     *
     * @return \OpenAPI\Client\Model\NodeVersion|null
     */
    public function getNodeVersion()
    {
        return $this->container['node_version'];
    }

    /**
     * Sets node_version
     *
     * @param \OpenAPI\Client\Model\NodeVersion|null $node_version node_version
     *
     * @return self
     */
    public function setNodeVersion($node_version)
    {
        if (is_null($node_version)) {
            throw new \InvalidArgumentException('non-nullable node_version cannot be null');
        }
        $this->container['node_version'] = $node_version;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


