<?php
/**
 * UiPreferences
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * orchd
 *
 * orchd API docs
 *
 * The version of the OpenAPI document: 12.13.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.17.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Model;

use \ArrayAccess;
use \OpenAPI\Client\ObjectSerializer;

/**
 * UiPreferences Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class UiPreferences implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'UiPreferences';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'login_id' => 'string',
        'file_manager_view' => '\OpenAPI\Client\Model\UiPreferencesViewKind',
        'website_view' => '\OpenAPI\Client\Model\UiPreferencesViewKind',
        'spine_open' => 'bool',
        'file_manager_editor_fullscreen' => 'bool',
        'server_groups' => 'string[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'login_id' => 'uuid',
        'file_manager_view' => null,
        'website_view' => null,
        'spine_open' => null,
        'file_manager_editor_fullscreen' => null,
        'server_groups' => 'uuid'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'login_id' => false,
        'file_manager_view' => false,
        'website_view' => false,
        'spine_open' => false,
        'file_manager_editor_fullscreen' => false,
        'server_groups' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'login_id' => 'loginId',
        'file_manager_view' => 'fileManagerView',
        'website_view' => 'websiteView',
        'spine_open' => 'spineOpen',
        'file_manager_editor_fullscreen' => 'fileManagerEditorFullscreen',
        'server_groups' => 'serverGroups'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'login_id' => 'setLoginId',
        'file_manager_view' => 'setFileManagerView',
        'website_view' => 'setWebsiteView',
        'spine_open' => 'setSpineOpen',
        'file_manager_editor_fullscreen' => 'setFileManagerEditorFullscreen',
        'server_groups' => 'setServerGroups'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'login_id' => 'getLoginId',
        'file_manager_view' => 'getFileManagerView',
        'website_view' => 'getWebsiteView',
        'spine_open' => 'getSpineOpen',
        'file_manager_editor_fullscreen' => 'getFileManagerEditorFullscreen',
        'server_groups' => 'getServerGroups'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('login_id', $data ?? [], null);
        $this->setIfExists('file_manager_view', $data ?? [], null);
        $this->setIfExists('website_view', $data ?? [], null);
        $this->setIfExists('spine_open', $data ?? [], null);
        $this->setIfExists('file_manager_editor_fullscreen', $data ?? [], null);
        $this->setIfExists('server_groups', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['login_id'] === null) {
            $invalidProperties[] = "'login_id' can't be null";
        }
        if ($this->container['file_manager_view'] === null) {
            $invalidProperties[] = "'file_manager_view' can't be null";
        }
        if ($this->container['website_view'] === null) {
            $invalidProperties[] = "'website_view' can't be null";
        }
        if ($this->container['spine_open'] === null) {
            $invalidProperties[] = "'spine_open' can't be null";
        }
        if ($this->container['file_manager_editor_fullscreen'] === null) {
            $invalidProperties[] = "'file_manager_editor_fullscreen' can't be null";
        }
        if ($this->container['server_groups'] === null) {
            $invalidProperties[] = "'server_groups' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets login_id
     *
     * @return string
     */
    public function getLoginId()
    {
        return $this->container['login_id'];
    }

    /**
     * Sets login_id
     *
     * @param string $login_id login_id
     *
     * @return self
     */
    public function setLoginId($login_id)
    {
        if (is_null($login_id)) {
            throw new \InvalidArgumentException('non-nullable login_id cannot be null');
        }
        $this->container['login_id'] = $login_id;

        return $this;
    }

    /**
     * Gets file_manager_view
     *
     * @return \OpenAPI\Client\Model\UiPreferencesViewKind
     */
    public function getFileManagerView()
    {
        return $this->container['file_manager_view'];
    }

    /**
     * Sets file_manager_view
     *
     * @param \OpenAPI\Client\Model\UiPreferencesViewKind $file_manager_view file_manager_view
     *
     * @return self
     */
    public function setFileManagerView($file_manager_view)
    {
        if (is_null($file_manager_view)) {
            throw new \InvalidArgumentException('non-nullable file_manager_view cannot be null');
        }
        $this->container['file_manager_view'] = $file_manager_view;

        return $this;
    }

    /**
     * Gets website_view
     *
     * @return \OpenAPI\Client\Model\UiPreferencesViewKind
     */
    public function getWebsiteView()
    {
        return $this->container['website_view'];
    }

    /**
     * Sets website_view
     *
     * @param \OpenAPI\Client\Model\UiPreferencesViewKind $website_view website_view
     *
     * @return self
     */
    public function setWebsiteView($website_view)
    {
        if (is_null($website_view)) {
            throw new \InvalidArgumentException('non-nullable website_view cannot be null');
        }
        $this->container['website_view'] = $website_view;

        return $this;
    }

    /**
     * Gets spine_open
     *
     * @return bool
     */
    public function getSpineOpen()
    {
        return $this->container['spine_open'];
    }

    /**
     * Sets spine_open
     *
     * @param bool $spine_open spine_open
     *
     * @return self
     */
    public function setSpineOpen($spine_open)
    {
        if (is_null($spine_open)) {
            throw new \InvalidArgumentException('non-nullable spine_open cannot be null');
        }
        $this->container['spine_open'] = $spine_open;

        return $this;
    }

    /**
     * Gets file_manager_editor_fullscreen
     *
     * @return bool
     */
    public function getFileManagerEditorFullscreen()
    {
        return $this->container['file_manager_editor_fullscreen'];
    }

    /**
     * Sets file_manager_editor_fullscreen
     *
     * @param bool $file_manager_editor_fullscreen file_manager_editor_fullscreen
     *
     * @return self
     */
    public function setFileManagerEditorFullscreen($file_manager_editor_fullscreen)
    {
        if (is_null($file_manager_editor_fullscreen)) {
            throw new \InvalidArgumentException('non-nullable file_manager_editor_fullscreen cannot be null');
        }
        $this->container['file_manager_editor_fullscreen'] = $file_manager_editor_fullscreen;

        return $this;
    }

    /**
     * Gets server_groups
     *
     * @return string[]
     */
    public function getServerGroups()
    {
        return $this->container['server_groups'];
    }

    /**
     * Sets server_groups
     *
     * @param string[] $server_groups server_groups
     *
     * @return self
     */
    public function setServerGroups($server_groups)
    {
        if (is_null($server_groups)) {
            throw new \InvalidArgumentException('non-nullable server_groups cannot be null');
        }
        $this->container['server_groups'] = $server_groups;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


