hostrecords_dispatch = function(){
    //we don't need to show the perform on server option as all of these changes only apply to server
    packagemanager.paneldescription = clientexec.lang("Point your domain to a web site by pointing to an IP Address, or forward to another site, or point to a temporary page (known as 'Parking'), and more. These records are also known as sub-domains (e.g. webmail.example.com).");
    positionAddZoneButton();
};


function positionAddZoneButton() {
  const $btn = $('#addhostrecord');
  const $container = $('#selectedproduct-view .custom-fields-row');

  if (!$container.length) return;

  // Move Add Zone Entry button below all blocks, left aligned
  $btn.detach()
      .appendTo($container)
      .wrap('<div class="col-12 mt-3"></div>')
      .removeClass('text-end')
      .css({
        'margin-left': '0',
        'display': 'inline-block'
      });
}

// delete the selected host entry
function hostrecords_deleteaddress(btn) {
    const $btn = $(btn);
    const match = $btn.attr('id').match(/^CT_(.+)_hostdelete$/);
    if (!match) return;

    const recordId = match[1];
    const $block = $('#hostname_CT_' + recordId).closest('.col-12');

    // Remove both the visible DNS row and the hidden field pair
    $block.remove();
    $('#CTT_' + recordId).remove();
    $('span[for="CTT_' + recordId + '"]').remove();
}


// add a new host entry
function hostrecords_addzoneentry() {
    if (typeof packagemanager.newhostrecordid === 'undefined') {
        packagemanager.newhostrecordid = 1;
    } else {
        packagemanager.newhostrecordid++;
    }

    // clone the hidden template row (the one with id suffix "_blankrecord")
    const $template = $('.custom-fields-row .col-12:hidden').first();
    const $clone = $template.clone(true, true).show();

    const newId = packagemanager.newhostrecordid;

    // update IDs/names inside clone
    $clone.find('[id],[name]').each(function () {
        const $el = $(this);
        $.each(['id', 'name', 'for'], function (_, attr) {
            const val = $el.attr(attr);
            if (val) {
                $el.attr(attr, val.replace(/_blankrecord/g, '_' + newId));
            }
        });
        // clear values
        if ($el.is('input[type=text]')) $el.val('');
    });

    // update delete button id and handler
    $clone.find('button[id^="CT_blankrecord_hostdelete"]')
        .attr('id', 'CT_' + newId + '_hostdelete')
        .attr('onclick', 'hostrecords_deleteaddress(this);');

    // insert before the Add button block
    $('#addhostrecord').closest('.col-12').before($clone);

    // hidden span/input pair
    const $hiddenSpan = $('<span>', {
        'for': 'CTT_' + newId,
        'class': 'customfield_hidden',
        css: { display: 'none' },
        text: newId
    });
    const $hiddenInput = $('<input>', {
        id: 'CTT_' + newId,
        name: newId,
        type: 'hidden',
        value: '50'
    });

    $('#addhostrecord').closest('.col-12').before($hiddenSpan, $hiddenInput);

    // re-initialize Select2 inside the new block
    $clone.find('select.select2').select2({
        dropdownParent: $('#addhostrecord').closest('.custom-fields-row'),
        width: '100%',
        minimumResultsForSearch: 35
    });
}
