<?php

require_once 'modules/admin/models/PluginCallback.php';
require_once 'modules/admin/models/StatusAliasGateway.php' ;
require_once 'modules/billing/models/class.gateway.plugin.php';
require_once 'modules/billing/models/Invoice_EventLog.php';
require_once 'modules/admin/models/Error_EventLog.php';

class PluginCoingateCallback extends PluginCallback
{
    public function processCallback()
    {
        \CoinGate\Client::setAppInfo("Clientexec", CE_Lib::getAppVersion());

        $invoiceId = $_POST['order_id'];
        $transactionId = $_POST['id'];
        $sandBox = false;
        if ($this->settings->get('plugin_coingate_Use Sandbox Mode?') == '1') {
            $sandBox = true;
        }

        $client = new CoinGate\Client($this->settings->get('plugin_coingate_Auth Token'), $sandBox);


        $order = $client->order->get($transactionId);

        $amount = (float)$order->price_amount;

        $cPlugin = new Plugin($invoiceId, "coingate", $this->user);
        $cPlugin->setAmount($invoiceData['price']);
        $cPlugin->setAction('charge');

        if ($order->status == 'paid') {
            $transaction = "CoinGate payment of {$amount} has been paid and confirmed.";
            $cPlugin->PaymentAccepted($amount, $transaction, $transactionId);
        } elseif ($order->status == 'confirming') {
            $transaction = "CoinGate payment of {$amount} has been received but not confirmed.";
            $cPlugin->PaymentPending($transaction, $transactionId);
        } elseif (in_array($order->status, ['canceled', 'expired', 'invalid'])) {
            $transaction = ucwords($order->status) . " Transaction ($transactionId)";
            $cPlugin->PaymentRejected($transaction);
        }
    }
}
