<?php
use Illuminate\Database\Capsule\Manager as Capsule;

/**
 * Coupon Code Usage Report
 *
 * @category Report
 * @package  ClientExec
 * @author   Juan D. Bolivar <juan@clientexec.com>
 * @license  ClientExec License
 * @version  1.0
 * @link     http://www.clientexec.com
 *
 *************************************************
 *   1.0 Initial Report Released.  - Juan D. Bolivar
 ************************************************
 */

require_once 'modules/billing/models/BillingType.php';

/**
 * Coupon_Code_Usage Report Class
 *
 * @category Report
 * @package  ClientExec
 * @author   Juan D. Bolivar <juan@clientexec.com>
 * @license  ClientExec License
 * @version  1.0
 * @link     http://www.clientexec.com
 */
class Coupon_Code_Usage extends Report
{
    private $lang;

    protected $featureSet = 'billing';

    function __construct($user = null, $customer = null)
    {
        $this->lang = lang('Coupon Code Usage');
        parent::__construct($user, $customer);
    }

    /**
     * Report Process Method
     *
     * @return null - direct output
     */
    function process()
    {
        // Set the report information
        $this->SetDescription($this->user->lang('Displays stats on usage of individual coupon codes.'));

        ?>

<script type="text/javascript">
    function viewCouponSelected(changedType)
    {
        var tagname =document.getElementsByTagName('input');
        for (var i = 0; i < tagname.length; i++) {
            if (tagname[i].type == 'radio' && tagname[i].checked == true) {
                var couponType = tagname[i].value;
            }
        }

        if (changedType == 1) {
            document.getElementById("coupons").value = 0;
        }

        location.href='index.php?fuse=reports&report=Coupon_Code_Usage&controller=index&type=Revenue&view=viewreport&couponId='+document.getElementById("coupons").value+'&isRecurring='+couponType+'&currencycode='+document.getElementById("currencycode").value;
    }
</script>
        <?php

        $aGroup = array();
        $i = 0;
        $selected_normal = "";
        $selected_recurring = "";
        $isRecurring = (isset($_GET['isRecurring']))? $_GET['isRecurring']:0;

        if (isset($_GET['isRecurring'])) {
            if ($_GET['isRecurring'] == 0) {
                $selected_normal = "checked";
            } else {
                $selected_recurring = "checked";
            }
        } else {
            $selected_normal = "checked";
        }

        echo "<div style='margin-left:20px;'>";
        echo '<label class="radio">';
        echo "<input type='radio' name='coupon_type' value='0' onChange='viewCouponSelected(1)' $selected_normal>";
        echo " Normal (non recurring)";
        echo '</label>';
        echo '<label class="radio">';
        echo "<input type='radio' name='coupon_type' value='1' onChange='viewCouponSelected(1)' $selected_recurring> Recurring";
        echo '</label>';
        echo "<br>".$this->user->lang('Select which coupon you want usage information on:')."<br/>";
        echo "<select id=coupons class='normalSelect2 w-25' name=coupons onChange='viewCouponSelected(0)'>";
        echo"<option value=0>".$this->user->lang('--- SELECT ONE ---')."</option>";

        $result = Capsule::table('coupons')
            ->select('coupons_id', 'coupons_name')
            ->distinct()
            ->where('coupons_recurring', $isRecurring)
            ->get();

        foreach ($result as $row) {
            if (isset($_GET['couponId']) && $_GET['couponId'] == $row->coupons_id) {
                echo"<option selected value=".$row->coupons_id.">".$row->coupons_name."</option>";
            } else {
                echo"<option value=".$row->coupons_id.">".$row->coupons_name."</option>";
            }
        }

        echo "</select>";

        // Load the currency information
        $currency = new Currency($this->user);

        $currencyCode = ((isset($_REQUEST['currencycode']))? $_REQUEST['currencycode'] : $this->settings->get('Default Currency'));
        $currencyName = $currency->getName($currencyCode);

        $filter = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'
            .'        '.$this->user->lang('Currency').': '
            .'        <select class="normalSelect2 w-25" name="currencycode" id="currencycode" value="'.CE_Lib::viewEscape($currencyCode).'" onChange="viewCouponSelected(0);"> ';

        $isSelectedCurrencyInTheList = false;

        //Get all currencies of all invoices
        $result = Capsule::table('invoice as i')
            ->join('currency as c', 'c.abrv', '=', 'i.currency')
            ->select('c.abrv', 'c.name')
            ->distinct()
            ->orderBy('c.name', 'ASC')
            ->get();

        foreach ($result as $row) {
            if (!$isSelectedCurrencyInTheList && $currencyName < $row->name) {
                $filter .= '<option value="'.$currencyCode.'" selected>'.$currencyName.'</option>';
                $isSelectedCurrencyInTheList = true;
            } elseif ($currencyCode == $row->abrv) {
                $isSelectedCurrencyInTheList = true;
            }

            $filter .= '<option value="'.$row->abrv.'" '.(($currencyCode == $row->abrv)? 'selected' : '').'>'.$row->name.'</option>';
        }

        if (!$isSelectedCurrencyInTheList) {
            $filter .= '<option value="'.$currencyCode.'" selected>'.$currencyName.'</option>';
            $isSelectedCurrencyInTheList = true;
        }

        $filter .= '</select>';
        echo $filter;
        echo "</div>";


        if (!isset($_GET['couponId'])) {
            $_GET['couponId'] = 0;
        }

        $result = Capsule::table('coupons')
            ->where('coupons_id', $_GET['couponId'])
            ->value('coupons_quantity');

        $totalNotUsedCoupons = $result;

        include_once 'modules/billing/models/Prices.php';
        $prices = new Prices();
        $totalSaved = 0;

        if ($isRecurring == 0) {
            $result = Capsule::table('invoiceentry as ie')
                ->join('coupons_usage as cu', 'ie.id', '=', 'cu.invoiceentryid')
                ->join('coupons as c', 'c.coupons_id', '=', 'cu.couponid')
                ->join('users as u', 'ie.customerid', '=', 'u.id')
                ->join('invoice as inv', 'ie.invoiceid', '=', 'inv.id')
                ->select(
                    'u.id',
                    'u.firstname',
                    'u.lastname',
                    'c.coupons_name',
                    'c.coupons_description',
                    'c.coupons_discount',
                    'c.coupons_type',
                    'c.coupons_archive',
                    'ie.invoiceid',
                    'ie.detail',
                    'inv.amount',
                    'ie.date',
                    'ie.price',
                    'ie.taxable',
                    'ie.taxamount'
                )
                ->where('cu.couponid', $_GET['couponId'])
                ->where('inv.currency', $currencyCode)
                ->get();
        } else {
            $result = Capsule::table('invoiceentry as ie')
                ->leftJoin('domains as d', 'ie.appliestoid', '=', 'd.id')
                ->join('coupons_usage as cu', 'ie.id', '=', 'cu.invoiceentryid')
                ->join('coupons as c', 'c.coupons_id', '=', 'cu.couponid')
                ->join('users as u', 'ie.customerid', '=', 'u.id')
                ->join('invoice as inv', 'ie.invoiceid', '=', 'inv.id')
                ->select(
                    'u.id',
                    'u.firstname',
                    'u.lastname',
                    'c.coupons_name',
                    'c.coupons_discount',
                    'c.coupons_type',
                    'c.coupons_archive',
                    'ie.invoiceid',
                    'ie.detail',
                    'inv.amount',
                    'ie.date',
                    'ie.price',
                    'ie.taxable',
                    'ie.taxamount'
                )
                ->where('cu.couponid', $_GET['couponId'])
                ->where('inv.currency', $currencyCode)
                ->get();
        }

        foreach ($result as $row) {
            $coupons_discount = $prices->getPricing(COUPON_PRICE, $_GET['couponId'], $currencyCode, $row->coupons_discount);

            if ($row->coupons_archive == 0) {
                $archived = $this->user->lang('No');
            } else {
                $archived = $this->user->lang('Yes');
            }

            $date = $this->convertDate($row->date);

            $invoiceSaved = 0;
            $invoiceSaved = -$row->price;

            if ($row->taxable) {
                $invoiceSaved -= $row->taxamount;
            }

            $totalSaved += $invoiceSaved;

            if ($row->coupons_type == 1) {
                $discountText = ($coupons_discount*100)."% (".$currency->format($currencyCode, $invoiceSaved, true).")";
            } else {
                $discountText = $currency->format($currencyCode, $invoiceSaved, true);
            }

            $aGroup[] = array("<a href=\"index.php?frmClientID=".$row->id."&fuse=clients&controller=userprofile&view=profilecontact\">".$row->lastname.", ".$row->firstname."</a>", $row->coupons_name, "<a href=index.php?fuse=billing&controller=invoice&frmClientID=".$row->id."&view=invoice&profile=1&invoiceid=".$row->invoiceid.">".$row->invoiceid."</a>", $date, $discountText, $currency->format($currencyCode, $row->amount, true), $row->detail, $archived);

            $i++;
        }

        if ($totalSaved > 0) {
            $aGroup[] = array('', '', '', '', '', '', $this->user->lang('<b>Total saved</b>'), '<b>'.$currency->format($currencyCode, $totalSaved, true).'</b>');
        }

        $this->SetDescription("<b>".(($totalNotUsedCoupons == -1) ? $this->user->lang('unlimited') : $totalNotUsedCoupons)."</b> ".$this->user->lang('Available coupons')."<br><b>".$i."</b> ".$this->user->lang('Coupons have already been used'));

        echo "<br><div style='margin-left:20px;'>";
        echo ("<b>".(($totalNotUsedCoupons == -1) ? $this->user->lang('unlimited') : $totalNotUsedCoupons)."</b> ".$this->user->lang('Available coupons')."<br><b>".$i."</b> ".$this->user->lang('Coupons have already been used'));
        echo "</div>";

        if (count($aGroup) > 0) {
            $this->reportData[] = array(
                "group"     => $aGroup,
                "groupname" => $this->user->lang('Customers').' ('.$currencyCode.')',
                "label"     => array(
                    $this->user->lang('Customer'),
                    $this->user->lang('Coupon Name'),
                    $this->user->lang('Invoice #'),
                    $this->user->lang('Date'),
                    $this->user->lang('Discount'),
                    $this->user->lang('Amount'),
                    $this->user->lang('Details'),
                    $this->user->lang('Archived')
                ),
                "groupId"   => "",
                "isHidden"  => false
            );
        } elseif ($_GET['couponId'] > 0) {
            echo "<br><b>THERE ARE NO CUSTOMERS USING THIS COUPON YET. ($currencyCode)</b><br><br>";
        }
    }

    function convertDate($date)
    {
        $date = date("F j, Y", strtotime($date));
        return $date;
    }
}
?>
