<?php
/**
 * BackupRestoreOptions
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * orchd
 *
 * orchd API docs
 *
 * The version of the OpenAPI document: 12.13.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.17.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Model;

use \ArrayAccess;
use \OpenAPI\Client\ObjectSerializer;

/**
 * BackupRestoreOptions Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class BackupRestoreOptions implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'BackupRestoreOptions';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'restore_files' => 'bool',
        'restore_emails' => 'string[]',
        'restore_all_emails' => 'bool',
        'restore_databases' => 'string[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'restore_files' => null,
        'restore_emails' => null,
        'restore_all_emails' => null,
        'restore_databases' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'restore_files' => false,
        'restore_emails' => false,
        'restore_all_emails' => false,
        'restore_databases' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'restore_files' => 'restoreFiles',
        'restore_emails' => 'restoreEmails',
        'restore_all_emails' => 'restoreAllEmails',
        'restore_databases' => 'restoreDatabases'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'restore_files' => 'setRestoreFiles',
        'restore_emails' => 'setRestoreEmails',
        'restore_all_emails' => 'setRestoreAllEmails',
        'restore_databases' => 'setRestoreDatabases'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'restore_files' => 'getRestoreFiles',
        'restore_emails' => 'getRestoreEmails',
        'restore_all_emails' => 'getRestoreAllEmails',
        'restore_databases' => 'getRestoreDatabases'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('restore_files', $data ?? [], true);
        $this->setIfExists('restore_emails', $data ?? [], null);
        $this->setIfExists('restore_all_emails', $data ?? [], null);
        $this->setIfExists('restore_databases', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets restore_files
     *
     * @return bool|null
     */
    public function getRestoreFiles()
    {
        return $this->container['restore_files'];
    }

    /**
     * Sets restore_files
     *
     * @param bool|null $restore_files If set to false, the backup restoration will not include the website home directory.
     *
     * @return self
     */
    public function setRestoreFiles($restore_files)
    {
        if (is_null($restore_files)) {
            throw new \InvalidArgumentException('non-nullable restore_files cannot be null');
        }
        $this->container['restore_files'] = $restore_files;

        return $this;
    }

    /**
     * Gets restore_emails
     *
     * @return string[]|null
     */
    public function getRestoreEmails()
    {
        return $this->container['restore_emails'];
    }

    /**
     * Sets restore_emails
     *
     * @param string[]|null $restore_emails restore_emails
     *
     * @return self
     */
    public function setRestoreEmails($restore_emails)
    {
        if (is_null($restore_emails)) {
            throw new \InvalidArgumentException('non-nullable restore_emails cannot be null');
        }
        $this->container['restore_emails'] = $restore_emails;

        return $this;
    }

    /**
     * Gets restore_all_emails
     *
     * @return bool|null
     */
    public function getRestoreAllEmails()
    {
        return $this->container['restore_all_emails'];
    }

    /**
     * Sets restore_all_emails
     *
     * @param bool|null $restore_all_emails Restore all the mailboxes from this backup.  Overrides the `restoreEmails` property.
     *
     * @return self
     */
    public function setRestoreAllEmails($restore_all_emails)
    {
        if (is_null($restore_all_emails)) {
            throw new \InvalidArgumentException('non-nullable restore_all_emails cannot be null');
        }
        $this->container['restore_all_emails'] = $restore_all_emails;

        return $this;
    }

    /**
     * Gets restore_databases
     *
     * @return string[]|null
     */
    public function getRestoreDatabases()
    {
        return $this->container['restore_databases'];
    }

    /**
     * Sets restore_databases
     *
     * @param string[]|null $restore_databases The list of databases names that need to be restored. If this list is not specified all the databases found in the backup snapshot will be restored, otherwise if this list is specified as empty, no database will be restored.
     *
     * @return self
     */
    public function setRestoreDatabases($restore_databases)
    {
        if (is_null($restore_databases)) {
            throw new \InvalidArgumentException('non-nullable restore_databases cannot be null');
        }
        $this->container['restore_databases'] = $restore_databases;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


