<?php
/**
 * GlobalWebsiteBackup
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * orchd
 *
 * orchd API docs
 *
 * The version of the OpenAPI document: 12.13.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.17.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Model;

use \ArrayAccess;
use \OpenAPI\Client\ObjectSerializer;

/**
 * GlobalWebsiteBackup Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class GlobalWebsiteBackup implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'GlobalWebsiteBackup';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'website_id' => 'string',
        'primary_domain' => 'string',
        'snapshot_id' => 'int',
        'emails_count' => 'int',
        'files_size' => 'int',
        'mysql_dbs_count' => 'int',
        'created_at' => 'string',
        'server_id' => 'string',
        'customer' => '\OpenAPI\Client\Model\Customer'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'website_id' => 'uuid',
        'primary_domain' => null,
        'snapshot_id' => null,
        'emails_count' => null,
        'files_size' => null,
        'mysql_dbs_count' => null,
        'created_at' => 'datetime',
        'server_id' => 'uuid',
        'customer' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'website_id' => false,
        'primary_domain' => false,
        'snapshot_id' => false,
        'emails_count' => false,
        'files_size' => false,
        'mysql_dbs_count' => false,
        'created_at' => false,
        'server_id' => false,
        'customer' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'website_id' => 'websiteId',
        'primary_domain' => 'primaryDomain',
        'snapshot_id' => 'snapshotId',
        'emails_count' => 'emailsCount',
        'files_size' => 'filesSize',
        'mysql_dbs_count' => 'mysqlDbsCount',
        'created_at' => 'createdAt',
        'server_id' => 'serverId',
        'customer' => 'customer'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'website_id' => 'setWebsiteId',
        'primary_domain' => 'setPrimaryDomain',
        'snapshot_id' => 'setSnapshotId',
        'emails_count' => 'setEmailsCount',
        'files_size' => 'setFilesSize',
        'mysql_dbs_count' => 'setMysqlDbsCount',
        'created_at' => 'setCreatedAt',
        'server_id' => 'setServerId',
        'customer' => 'setCustomer'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'website_id' => 'getWebsiteId',
        'primary_domain' => 'getPrimaryDomain',
        'snapshot_id' => 'getSnapshotId',
        'emails_count' => 'getEmailsCount',
        'files_size' => 'getFilesSize',
        'mysql_dbs_count' => 'getMysqlDbsCount',
        'created_at' => 'getCreatedAt',
        'server_id' => 'getServerId',
        'customer' => 'getCustomer'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('website_id', $data ?? [], null);
        $this->setIfExists('primary_domain', $data ?? [], null);
        $this->setIfExists('snapshot_id', $data ?? [], null);
        $this->setIfExists('emails_count', $data ?? [], null);
        $this->setIfExists('files_size', $data ?? [], null);
        $this->setIfExists('mysql_dbs_count', $data ?? [], null);
        $this->setIfExists('created_at', $data ?? [], null);
        $this->setIfExists('server_id', $data ?? [], null);
        $this->setIfExists('customer', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['website_id'] === null) {
            $invalidProperties[] = "'website_id' can't be null";
        }
        if ($this->container['primary_domain'] === null) {
            $invalidProperties[] = "'primary_domain' can't be null";
        }
        if ($this->container['snapshot_id'] === null) {
            $invalidProperties[] = "'snapshot_id' can't be null";
        }
        if ($this->container['files_size'] === null) {
            $invalidProperties[] = "'files_size' can't be null";
        }
        if ($this->container['mysql_dbs_count'] === null) {
            $invalidProperties[] = "'mysql_dbs_count' can't be null";
        }
        if ($this->container['created_at'] === null) {
            $invalidProperties[] = "'created_at' can't be null";
        }
        if ($this->container['server_id'] === null) {
            $invalidProperties[] = "'server_id' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets website_id
     *
     * @return string
     */
    public function getWebsiteId()
    {
        return $this->container['website_id'];
    }

    /**
     * Sets website_id
     *
     * @param string $website_id website_id
     *
     * @return self
     */
    public function setWebsiteId($website_id)
    {
        if (is_null($website_id)) {
            throw new \InvalidArgumentException('non-nullable website_id cannot be null');
        }
        $this->container['website_id'] = $website_id;

        return $this;
    }

    /**
     * Gets primary_domain
     *
     * @return string
     */
    public function getPrimaryDomain()
    {
        return $this->container['primary_domain'];
    }

    /**
     * Sets primary_domain
     *
     * @param string $primary_domain primary_domain
     *
     * @return self
     */
    public function setPrimaryDomain($primary_domain)
    {
        if (is_null($primary_domain)) {
            throw new \InvalidArgumentException('non-nullable primary_domain cannot be null');
        }
        $this->container['primary_domain'] = $primary_domain;

        return $this;
    }

    /**
     * Gets snapshot_id
     *
     * @return int
     */
    public function getSnapshotId()
    {
        return $this->container['snapshot_id'];
    }

    /**
     * Sets snapshot_id
     *
     * @param int $snapshot_id snapshot_id
     *
     * @return self
     */
    public function setSnapshotId($snapshot_id)
    {
        if (is_null($snapshot_id)) {
            throw new \InvalidArgumentException('non-nullable snapshot_id cannot be null');
        }
        $this->container['snapshot_id'] = $snapshot_id;

        return $this;
    }

    /**
     * Gets emails_count
     *
     * @return int|null
     */
    public function getEmailsCount()
    {
        return $this->container['emails_count'];
    }

    /**
     * Sets emails_count
     *
     * @param int|null $emails_count emails_count
     *
     * @return self
     */
    public function setEmailsCount($emails_count)
    {
        if (is_null($emails_count)) {
            throw new \InvalidArgumentException('non-nullable emails_count cannot be null');
        }
        $this->container['emails_count'] = $emails_count;

        return $this;
    }

    /**
     * Gets files_size
     *
     * @return int
     */
    public function getFilesSize()
    {
        return $this->container['files_size'];
    }

    /**
     * Sets files_size
     *
     * @param int $files_size files_size
     *
     * @return self
     */
    public function setFilesSize($files_size)
    {
        if (is_null($files_size)) {
            throw new \InvalidArgumentException('non-nullable files_size cannot be null');
        }
        $this->container['files_size'] = $files_size;

        return $this;
    }

    /**
     * Gets mysql_dbs_count
     *
     * @return int
     */
    public function getMysqlDbsCount()
    {
        return $this->container['mysql_dbs_count'];
    }

    /**
     * Sets mysql_dbs_count
     *
     * @param int $mysql_dbs_count mysql_dbs_count
     *
     * @return self
     */
    public function setMysqlDbsCount($mysql_dbs_count)
    {
        if (is_null($mysql_dbs_count)) {
            throw new \InvalidArgumentException('non-nullable mysql_dbs_count cannot be null');
        }
        $this->container['mysql_dbs_count'] = $mysql_dbs_count;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return string
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param string $created_at created_at
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        if (is_null($created_at)) {
            throw new \InvalidArgumentException('non-nullable created_at cannot be null');
        }
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets server_id
     *
     * @return string
     */
    public function getServerId()
    {
        return $this->container['server_id'];
    }

    /**
     * Sets server_id
     *
     * @param string $server_id server_id
     *
     * @return self
     */
    public function setServerId($server_id)
    {
        if (is_null($server_id)) {
            throw new \InvalidArgumentException('non-nullable server_id cannot be null');
        }
        $this->container['server_id'] = $server_id;

        return $this;
    }

    /**
     * Gets customer
     *
     * @return \OpenAPI\Client\Model\Customer|null
     */
    public function getCustomer()
    {
        return $this->container['customer'];
    }

    /**
     * Sets customer
     *
     * @param \OpenAPI\Client\Model\Customer|null $customer customer
     *
     * @return self
     */
    public function setCustomer($customer)
    {
        if (is_null($customer)) {
            throw new \InvalidArgumentException('non-nullable customer cannot be null');
        }
        $this->container['customer'] = $customer;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


