<?php
/**
 * Login
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * orchd
 *
 * orchd API docs
 *
 * The version of the OpenAPI document: 12.13.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.17.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Model;

use \ArrayAccess;
use \OpenAPI\Client\ObjectSerializer;

/**
 * Login Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Login implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Login';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'email' => 'string',
        'name' => 'string',
        'color_code' => 'string',
        'registered_at' => 'string',
        'avatar_path' => 'string',
        'password_last_changed_at' => 'string',
        'auth_method' => 'string',
        'locale' => '\OpenAPI\Client\Model\CPLocale'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'uuid',
        'email' => 'email',
        'name' => null,
        'color_code' => null,
        'registered_at' => null,
        'avatar_path' => 'path',
        'password_last_changed_at' => null,
        'auth_method' => null,
        'locale' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'email' => false,
        'name' => false,
        'color_code' => false,
        'registered_at' => false,
        'avatar_path' => false,
        'password_last_changed_at' => false,
        'auth_method' => false,
        'locale' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'email' => 'email',
        'name' => 'name',
        'color_code' => 'colorCode',
        'registered_at' => 'registeredAt',
        'avatar_path' => 'avatarPath',
        'password_last_changed_at' => 'passwordLastChangedAt',
        'auth_method' => 'authMethod',
        'locale' => 'locale'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'email' => 'setEmail',
        'name' => 'setName',
        'color_code' => 'setColorCode',
        'registered_at' => 'setRegisteredAt',
        'avatar_path' => 'setAvatarPath',
        'password_last_changed_at' => 'setPasswordLastChangedAt',
        'auth_method' => 'setAuthMethod',
        'locale' => 'setLocale'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'email' => 'getEmail',
        'name' => 'getName',
        'color_code' => 'getColorCode',
        'registered_at' => 'getRegisteredAt',
        'avatar_path' => 'getAvatarPath',
        'password_last_changed_at' => 'getPasswordLastChangedAt',
        'auth_method' => 'getAuthMethod',
        'locale' => 'getLocale'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const AUTH_METHOD_BASIC = 'basic';
    public const AUTH_METHOD_EMAIL = 'email';
    public const AUTH_METHOD_OTP = 'otp';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getAuthMethodAllowableValues()
    {
        return [
            self::AUTH_METHOD_BASIC,
            self::AUTH_METHOD_EMAIL,
            self::AUTH_METHOD_OTP,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('email', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('color_code', $data ?? [], null);
        $this->setIfExists('registered_at', $data ?? [], null);
        $this->setIfExists('avatar_path', $data ?? [], null);
        $this->setIfExists('password_last_changed_at', $data ?? [], null);
        $this->setIfExists('auth_method', $data ?? [], null);
        $this->setIfExists('locale', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['id'] === null) {
            $invalidProperties[] = "'id' can't be null";
        }
        if ($this->container['email'] === null) {
            $invalidProperties[] = "'email' can't be null";
        }
        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if ($this->container['color_code'] === null) {
            $invalidProperties[] = "'color_code' can't be null";
        }
        if ($this->container['registered_at'] === null) {
            $invalidProperties[] = "'registered_at' can't be null";
        }
        if ($this->container['auth_method'] === null) {
            $invalidProperties[] = "'auth_method' can't be null";
        }
        $allowedValues = $this->getAuthMethodAllowableValues();
        if (!is_null($this->container['auth_method']) && !in_array($this->container['auth_method'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'auth_method', must be one of '%s'",
                $this->container['auth_method'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['locale'] === null) {
            $invalidProperties[] = "'locale' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string $email email
     *
     * @return self
     */
    public function setEmail($email)
    {
        if (is_null($email)) {
            throw new \InvalidArgumentException('non-nullable email cannot be null');
        }
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name name
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets color_code
     *
     * @return string
     */
    public function getColorCode()
    {
        return $this->container['color_code'];
    }

    /**
     * Sets color_code
     *
     * @param string $color_code color_code
     *
     * @return self
     */
    public function setColorCode($color_code)
    {
        if (is_null($color_code)) {
            throw new \InvalidArgumentException('non-nullable color_code cannot be null');
        }
        $this->container['color_code'] = $color_code;

        return $this;
    }

    /**
     * Gets registered_at
     *
     * @return string
     */
    public function getRegisteredAt()
    {
        return $this->container['registered_at'];
    }

    /**
     * Sets registered_at
     *
     * @param string $registered_at registered_at
     *
     * @return self
     */
    public function setRegisteredAt($registered_at)
    {
        if (is_null($registered_at)) {
            throw new \InvalidArgumentException('non-nullable registered_at cannot be null');
        }
        $this->container['registered_at'] = $registered_at;

        return $this;
    }

    /**
     * Gets avatar_path
     *
     * @return string|null
     */
    public function getAvatarPath()
    {
        return $this->container['avatar_path'];
    }

    /**
     * Sets avatar_path
     *
     * @param string|null $avatar_path avatar_path
     *
     * @return self
     */
    public function setAvatarPath($avatar_path)
    {
        if (is_null($avatar_path)) {
            throw new \InvalidArgumentException('non-nullable avatar_path cannot be null');
        }
        $this->container['avatar_path'] = $avatar_path;

        return $this;
    }

    /**
     * Gets password_last_changed_at
     *
     * @return string|null
     */
    public function getPasswordLastChangedAt()
    {
        return $this->container['password_last_changed_at'];
    }

    /**
     * Sets password_last_changed_at
     *
     * @param string|null $password_last_changed_at password_last_changed_at
     *
     * @return self
     */
    public function setPasswordLastChangedAt($password_last_changed_at)
    {
        if (is_null($password_last_changed_at)) {
            throw new \InvalidArgumentException('non-nullable password_last_changed_at cannot be null');
        }
        $this->container['password_last_changed_at'] = $password_last_changed_at;

        return $this;
    }

    /**
     * Gets auth_method
     *
     * @return string
     */
    public function getAuthMethod()
    {
        return $this->container['auth_method'];
    }

    /**
     * Sets auth_method
     *
     * @param string $auth_method auth_method
     *
     * @return self
     */
    public function setAuthMethod($auth_method)
    {
        if (is_null($auth_method)) {
            throw new \InvalidArgumentException('non-nullable auth_method cannot be null');
        }
        $allowedValues = $this->getAuthMethodAllowableValues();
        if (!in_array($auth_method, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'auth_method', must be one of '%s'",
                    $auth_method,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['auth_method'] = $auth_method;

        return $this;
    }

    /**
     * Gets locale
     *
     * @return \OpenAPI\Client\Model\CPLocale
     */
    public function getLocale()
    {
        return $this->container['locale'];
    }

    /**
     * Sets locale
     *
     * @param \OpenAPI\Client\Model\CPLocale $locale locale
     *
     * @return self
     */
    public function setLocale($locale)
    {
        if (is_null($locale)) {
            throw new \InvalidArgumentException('non-nullable locale cannot be null');
        }
        $this->container['locale'] = $locale;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


