<?php
/**
 * ServerStatEntry
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * orchd
 *
 * orchd API docs
 *
 * The version of the OpenAPI document: 12.13.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.17.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Model;

use \ArrayAccess;
use \OpenAPI\Client\ObjectSerializer;

/**
 * ServerStatEntry Class Doc Comment
 *
 * @category Class
 * @description Each entry represts server stats recorded periodically
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ServerStatEntry implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ServerStatEntry';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'server_id' => 'string',
        'io_wait' => 'float',
        'ram_usage' => 'float',
        'swap_usage' => 'float',
        'system_load' => 'float',
        'uptime' => 'float',
        'recorded_at' => '\DateTime'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'server_id' => 'uuid',
        'io_wait' => null,
        'ram_usage' => null,
        'swap_usage' => null,
        'system_load' => null,
        'uptime' => null,
        'recorded_at' => 'date-time'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'server_id' => false,
        'io_wait' => false,
        'ram_usage' => false,
        'swap_usage' => false,
        'system_load' => false,
        'uptime' => false,
        'recorded_at' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'server_id' => 'serverId',
        'io_wait' => 'ioWait',
        'ram_usage' => 'ramUsage',
        'swap_usage' => 'swapUsage',
        'system_load' => 'systemLoad',
        'uptime' => 'uptime',
        'recorded_at' => 'recordedAt'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'server_id' => 'setServerId',
        'io_wait' => 'setIoWait',
        'ram_usage' => 'setRamUsage',
        'swap_usage' => 'setSwapUsage',
        'system_load' => 'setSystemLoad',
        'uptime' => 'setUptime',
        'recorded_at' => 'setRecordedAt'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'server_id' => 'getServerId',
        'io_wait' => 'getIoWait',
        'ram_usage' => 'getRamUsage',
        'swap_usage' => 'getSwapUsage',
        'system_load' => 'getSystemLoad',
        'uptime' => 'getUptime',
        'recorded_at' => 'getRecordedAt'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('server_id', $data ?? [], null);
        $this->setIfExists('io_wait', $data ?? [], null);
        $this->setIfExists('ram_usage', $data ?? [], null);
        $this->setIfExists('swap_usage', $data ?? [], null);
        $this->setIfExists('system_load', $data ?? [], null);
        $this->setIfExists('uptime', $data ?? [], null);
        $this->setIfExists('recorded_at', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['server_id'] === null) {
            $invalidProperties[] = "'server_id' can't be null";
        }
        if ($this->container['io_wait'] === null) {
            $invalidProperties[] = "'io_wait' can't be null";
        }
        if ($this->container['ram_usage'] === null) {
            $invalidProperties[] = "'ram_usage' can't be null";
        }
        if ($this->container['swap_usage'] === null) {
            $invalidProperties[] = "'swap_usage' can't be null";
        }
        if ($this->container['system_load'] === null) {
            $invalidProperties[] = "'system_load' can't be null";
        }
        if ($this->container['uptime'] === null) {
            $invalidProperties[] = "'uptime' can't be null";
        }
        if ($this->container['recorded_at'] === null) {
            $invalidProperties[] = "'recorded_at' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets server_id
     *
     * @return string
     */
    public function getServerId()
    {
        return $this->container['server_id'];
    }

    /**
     * Sets server_id
     *
     * @param string $server_id server_id
     *
     * @return self
     */
    public function setServerId($server_id)
    {
        if (is_null($server_id)) {
            throw new \InvalidArgumentException('non-nullable server_id cannot be null');
        }
        $this->container['server_id'] = $server_id;

        return $this;
    }

    /**
     * Gets io_wait
     *
     * @return float
     */
    public function getIoWait()
    {
        return $this->container['io_wait'];
    }

    /**
     * Sets io_wait
     *
     * @param float $io_wait io_wait
     *
     * @return self
     */
    public function setIoWait($io_wait)
    {
        if (is_null($io_wait)) {
            throw new \InvalidArgumentException('non-nullable io_wait cannot be null');
        }
        $this->container['io_wait'] = $io_wait;

        return $this;
    }

    /**
     * Gets ram_usage
     *
     * @return float
     */
    public function getRamUsage()
    {
        return $this->container['ram_usage'];
    }

    /**
     * Sets ram_usage
     *
     * @param float $ram_usage ram_usage
     *
     * @return self
     */
    public function setRamUsage($ram_usage)
    {
        if (is_null($ram_usage)) {
            throw new \InvalidArgumentException('non-nullable ram_usage cannot be null');
        }
        $this->container['ram_usage'] = $ram_usage;

        return $this;
    }

    /**
     * Gets swap_usage
     *
     * @return float
     */
    public function getSwapUsage()
    {
        return $this->container['swap_usage'];
    }

    /**
     * Sets swap_usage
     *
     * @param float $swap_usage swap_usage
     *
     * @return self
     */
    public function setSwapUsage($swap_usage)
    {
        if (is_null($swap_usage)) {
            throw new \InvalidArgumentException('non-nullable swap_usage cannot be null');
        }
        $this->container['swap_usage'] = $swap_usage;

        return $this;
    }

    /**
     * Gets system_load
     *
     * @return float
     */
    public function getSystemLoad()
    {
        return $this->container['system_load'];
    }

    /**
     * Sets system_load
     *
     * @param float $system_load system_load
     *
     * @return self
     */
    public function setSystemLoad($system_load)
    {
        if (is_null($system_load)) {
            throw new \InvalidArgumentException('non-nullable system_load cannot be null');
        }
        $this->container['system_load'] = $system_load;

        return $this;
    }

    /**
     * Gets uptime
     *
     * @return float
     */
    public function getUptime()
    {
        return $this->container['uptime'];
    }

    /**
     * Sets uptime
     *
     * @param float $uptime uptime
     *
     * @return self
     */
    public function setUptime($uptime)
    {
        if (is_null($uptime)) {
            throw new \InvalidArgumentException('non-nullable uptime cannot be null');
        }
        $this->container['uptime'] = $uptime;

        return $this;
    }

    /**
     * Gets recorded_at
     *
     * @return \DateTime
     */
    public function getRecordedAt()
    {
        return $this->container['recorded_at'];
    }

    /**
     * Sets recorded_at
     *
     * @param \DateTime $recorded_at Time when the entry was recorded
     *
     * @return self
     */
    public function setRecordedAt($recorded_at)
    {
        if (is_null($recorded_at)) {
            throw new \InvalidArgumentException('non-nullable recorded_at cannot be null');
        }
        $this->container['recorded_at'] = $recorded_at;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


