productview.all_general_load = function () {
    $('#product-tab-content').load(
        'index.php?nolog=1&fuse=admin&controller=products&view=generaltab&groupid=' +
            productview.groupid +
            '&productid=' +
            productview.productid,
        productview.postloadactions_general
    );
};

productview.postloadactions_general = function (e) {
    clientexec.postPageLoad('#product-tab-content');

    // Init Parsley on the form
    var $form = $('#generaltab').parsley();

    $("#bundledproducts").select2({
        templateSelection: function (item) {
            var name = item.text;
            if (productview.bundleProducts.optionalIds.indexOf(item.id) >= 0) {
                name = name + " (optional)";
            }
            return $("<span class='select2-bundledoption' data-id='" + item.id + "'>" + name + "</span>");
        }
    });

    $("#bundledproducts").on("change", function (e) {
        // productview.askifbundleisoptional(e);
    });

    $('#mainlanguageproductname').trigger('focus');

    $('#stockEnable').on('click', function () {
        $('.stockcontrolswitch').toggle();
    });

    $('#bundledomain').on('click', function () {
        $('.bundle_domains_fields').toggle();
        if ($('.bundle_domains_fields:visible').length === 0) {
            $("#domain_bundles_dropdown").val("0").trigger("change");
        }
    });

    $('#bundlessl').on('click', function () {
        $('.bundle_ssl_fields').toggle();
        if ($('.bundle_ssl_fields:visible').length === 0) {
            $("#ssl_bundles_dropdown").val("0").trigger("change");
        }
    });

    $('.submit-general').on('click', function (e) {
        e.preventDefault();

        var pass = true;

        // Validate form with Parsley
        if (productview.productType == 3) {
            if ($.trim($('#mainlanguageproductname').val()).charAt(0) === ".") {
                $('#mainlanguageproductname').val($('#mainlanguageproductname').val().substr(1));
            }

            $form.validate();
            if (!$form.isValid()) {
                pass = false;
            }
        } else {
            // Ensure first language tab is active
            if (!$(".nav-pills .nav-link:first").hasClass("active")) {
                $(".default-language-tab").trigger('click');
            }

            $form.validate();
            if (!$form.isValid()) {
                pass = false;
            }
        }

        if (!pass) {
            return false;
        }

        var fielddata = $('#generaltab').serializeArray();
        fielddata.push({ name: 'bundledOptionalIds', value: productview.bundleProducts.optionalIds });
        fielddata.push({ name: 'producttype', value: productview.producttype });

        $.ajax({
            url:
                'index.php?fuse=admin&tab=general&controller=products&action=saveproduct&packageId=' +
                productview.productid +
                '&groupid=' +
                productview.groupid,
            type: 'POST',
            data: fielddata,
            success: function (xhr) {
                var json = clientexec.parseResponse(xhr);

                if (json.isnew) {
                    productview.productid = json.packageId;
                    $('ul.productnav li span').off('click', productview.bindproducttabs);
                    productview.addtabs(productview.producttype);

                    $('ul.productnav li span[data-type="all-general"]').trigger('click');
                    //History.pushState({}, "", window.location.href.toString() + "&id=" + json.packageId);
                }
            }
        });
    });

    document.querySelectorAll('#product-tab-content [data-bs-toggle="tooltip"]').forEach(function (el) {
        new bootstrap.Tooltip(el);
    });
};

productview.askifbundleisoptional = function (e) {
    if (e.added) {
        RichHTML.alert(
            'Is this an optional bundled product?<br/>Clicking Yes allows clients to skip this product.',
            '',
            function (ret) {
                var optional = false;
                var el = $('.select2-bundledoption[data-id="' + e.added.id + '"]');
                if (ret.btn == clientexec.lang('Yes')) {
                    optional = true;
                    el.text(el.text() + " (optional)");
                }

                // Remove if exists
                var idx = productview.bundleProducts.optionalIds.indexOf(e.added.id);
                if (idx >= 0) {
                    productview.bundleProducts.optionalIds.splice(idx, 1);
                }

                // Add if optional
                if (optional) {
                    productview.bundleProducts.optionalIds.push(e.added.id);
                }
            }
        );
    } else if (e.removed) {
        var idx = productview.bundleProducts.optionalIds.indexOf(e.removed.id);
        if (idx >= 0) {
            productview.bundleProducts.optionalIds.splice(idx, 1);
        }
    }
};
