productview.tlds = {};

productview.domains_pricing_load = function (currency = 'default')
{
    $('#product-tab-content').load(
        'index.php?nolog=1&fuse=admin&controller=products&view=pricingtabfordomains&groupid='+productview.groupid+'&productid='+productview.productid+'&currency='+currency,
        productview.postloadactions_domainspricing
    );
};

productview.postloadactions_domainspricing = function ()
{
    var table = $('#pricing-list').DataTable({
        order: false,
        searching: false,
        select: {
            style: 'multi',
            selector: 'td:first-child'
        },
        "ajax": {
            url: 'index.php?fuse=admin&controller=products&action=gettldsgrid&productId='+productview.productid+'&currency='+productview.currency.abrv,
            dataSrc: 'results',
        },
        columnDefs: [
            {
                targets: 0,
                "orderable": false,
                className: 'select-checkbox',
                checkboxes: { selectRow: true },
                width: '1%'
            }
        ],
        "columns": [
            { data: null, defaultContent: '', orderable: false, },
            {
                "data": "period",
                render: function (text, type, row) {
                    var label = row.name;
                    return "<a href='javascript:void(0)' onclick='productview.tlds.showperiodwindow(\""+row.tldraw+"\",\""+text+"\");' class='link'>"+label+"</a>";
                },
            },
            {
                "data": "price",
                render: function (text, type, record) {
                    if (record.period == "none") {
                        return "";
                    }
                    return accounting.formatMoney(text, productview.currency.symbol, productview.currency.precision, productview.currency.thousandssep, productview.currency.decimalssep, productview.currency.alignment);
                }
            },
            {
                "data": "transfer",
                 render: function (text, type, record) {
                    if (record.period == "none") {
                        return "";
                    }
                    return accounting.formatMoney(text, productview.currency.symbol, productview.currency.precision, productview.currency.thousandssep, productview.currency.decimalssep, productview.currency.alignment);
                }
            },
            {
                "data": "renew",
                 render: function (text, type, record) {
                    if (record.period == "none") {
                        return "";
                    }
                    return accounting.formatMoney(text, productview.currency.symbol, productview.currency.precision, productview.currency.thousandssep, productview.currency.decimalssep, productview.currency.alignment);
                }
            },
        ],
    });

    table.on('select.dt deselect.dt', function() {
        var selectedRows = table.rows({ selected: true }).count();
        if (selectedRows > 0) {
            $('.table-actions .action-buttons').prop('disabled', false);
        } else {
            $('.table-actions .action-buttons').prop('disabled', true);
        }
    });































    productview.tlds.columns = [
        {
            id:        'cb',
            dataIndex: 'id',
            xtype:     'checkbox',
            renderer:  function (text,record,el)
            {
                if (record.period == "none") {
                    el.addClass = "hide-checkbox";
                }
            }
        },{
            id:        'period',
            dataIndex: 'period',
            text:      clientexec.lang('Billing Period(s)'),
            sortable:  false,
            align:     'left',
            flex:      1,
            renderer:  function (text,record)
            {
                var label = record.name;

                if (text ==  "none") {
                    label = "<span style='position: relative;left: -30px;' class='label label-important'>No pricing exists for this tld.  Click to add one.</span>";
                }

                return "<a href='javascript:void(0)' onclick='productview.tlds.showperiodwindow(\""+record.tldraw+"\",\""+text+"\");' class='link'>"+label+"</a>";
            }
        },{
            id:        'price',
            dataIndex: 'price',
            text:      clientexec.lang('Price'),
            sortable:  false,
            width:     '60',
            align:     'right',
            renderer:  function (text,record)
            {
                if (record.period == "none") {
                    return "";
                }

                return accounting.formatMoney(text, productview.currency.symbol, productview.currency.precision, productview.currency.thousandssep, productview.currency.decimalssep, productview.currency.alignment);
            }
        },{
            id:        'transfer',
            dataIndex: 'transfer',
            text:      clientexec.lang('Transfer'),
            sortable:  false,
            width:     '60',
            align:     'right',
            renderer:  function (text,record)
            {
                if (record.period == "none") {
                    return "";
                }

                if (text == '') {
                    return clientexec.lang('N/A')
                }

                return accounting.formatMoney(text, productview.currency.symbol, productview.currency.precision, productview.currency.thousandssep, productview.currency.decimalssep, productview.currency.alignment);
            }
        },{
            id:        'renew',
            dataIndex: 'renew',
            text:      clientexec.lang('Renew'),
            sortable:  false,
            width:     '60',
            align:     'right',
            renderer:  function (text,record)
            {
                if (record.period == "none") {
                    return "";
                }

                return accounting.formatMoney(text, productview.currency.symbol, productview.currency.precision, productview.currency.thousandssep, productview.currency.decimalssep, productview.currency.alignment);
            }
        }
    ];

    productview.tlds.periodwindow = new RichHTML.window(
        {
            id: 'groupwindow',
            url: 'index.php?fuse=admin&controller=products&view=tldperiod&currency='+productview.currency.abrv,
            actionUrl: 'index.php?fuse=admin&controller=products&action=savetldperiod&currency='+productview.currency.abrv,
            width: '320',
            height: '150',
            grid: table,
            showSubmit: true,
            title: clientexec.lang("TLD Setup Window")
        }
    );

    //let's determine if we want to make the product groups editable
    productview.tlds.showperiodwindow = function (tld,period)
    {
        if (!period) {
            period = "none";
        }

        productview.tlds.periodwindow.show(
            {
                params: {
                    period:    period,
                    tld:       tld,
                    productid: productview.productid,
                    currency:  productview.currency.abrv
                }
            }
        );
    };
    
    $('#taxdomainorders').click(
        function ()
        {
            $.post(
                "index.php?fuse=admin&controller=products&action=updatedomaintax",
                {
                    productid: productview.productid,
                    taxable:   $(this).is(':checked'),
                    currency:  productview.currency.abrv
                },
                function (data)
                {
                    json = clientexec.parseResponse(data);
                }
            );
        }
    );

    $('#latefee').change(
        function ()
        {
            $.post(
                "index.php?fuse=admin&controller=products&action=updatedomainlatefee",
                {
                    productid: productview.productid,
                    latefee:   $(this).val(),
                    currency:  productview.currency.abrv
                },
                function (data)
                {
                    json = clientexec.parseResponse(data);
                }
            );
        }
    );

    $('#delete-button').click(
        function ()
        {
            if ($(this).attr('disabled')) {
                return false;
            }

            RichHTML.msgBox(
                clientexec.lang('Are you sure you want to delete the selected TLD billing period(s)'),
                {
                    type:"yesno"
                },
                function (result)
                {
                    if(result.btn === clientexec.lang("Yes")) {
                        $.post(
                            "index.php?fuse=admin&controller=products&action=deleteTldPeriod",
                            {
                                productid: productview.productid,
                                ids:       table.getSelectedRows(),
                                currency:  productview.currency.abrv
                            },
                            function (data)
                            {
                               table.ajax.reload();
                            }
                        );
                    }
                }
            );
        }
    );
};