var nameservers_dispatch = function(){
    //setup environment for hosting
    packagemanager.paneldescription = "Point DNS Servers here. If you set your domain to use the default Name Servers, you will be able to use the plugin's additional services when available, for example Email services provided by eNom.";

    var addBtn = $('#addnameserver').closest('.col-sm-6');

    // Move it right after the .custom-fields-row container
    $('.custom-fields-row').after(addBtn);
};

function nameservers_ChangeUseDefaults() {
    const useDefaults = $('#ns_usedefaults').val();
    const container = $('#selectedproduct-view .custom-fields-row');

    // Remove any previously inserted row breaks
    container.find('.dynamic-rowbreak').remove();

    if (useDefaults === "0") {
        // Show all fields except Use Defaults and Blankrecord
        container.find('.col-sm-6')
            .not(':has(#ns_usedefaults), :has(#blankrecord)')
            .show()
            .find('label').show();

        const useDefaultsCol = container.find(':has(#ns_usedefaults)');
        $('<div class="w-100 d-none d-sm-block dynamic-rowbreak"></div>')
            .insertAfter(useDefaultsCol);

        $('#addnameserver').closest('.col-sm-6').show();

    } else {
        // Hide all fields except Use Defaults and Blankrecord
        container.find('.col-sm-6')
            .not(':has(#ns_usedefaults), :has(#blankrecord)')
            .hide()
            .find('label').hide();

        $('#addnameserver').closest('.col-sm-6').hide();
    }
}





function nameservers_addnameserver() {
    var useDefaults = $('#ns_usedefaults').val();
    if (useDefaults === "1") {
        RichHTML.error(
            clientexec.lang('The setting <strong>Use Defaults</strong> must be set to No if you want to add your own Name Server')
        );
        return;
    }

    // Count only visible nameservers (ignore hidden template)
    var nth = $('.custom-fields-row input.nameserver:visible').length + 1;
    var nsId = 'ns_' + nth;
    var serverName = 'Name Server ' + nth;

    // --- Label ---
    var $label = $('<label>', {
        for: nsId,
        class: 'form-label fw-semibold',
        text: serverName
    });

    // --- Input ---
    var $input = $('<input>', {
        class: 'form-control nameserver',
        id: nsId,
        name: nsId,
        type: 'text',
        value: ''
    });

    // --- Delete Button ---
    var $deleteBtn = $('<button>', {
        type: 'button',
        id: nsId + '_nameserverdelete',
        class: 'btn btn-outline-danger',
        text: 'Delete',
        click: function () {
            nameservers_deleteaddress(this);
        }
    });

    // --- Layout wrappers ---
    var $inputWrapper = $('<div>', { class: 'flex-grow-1' }).append($input);
    var $btnWrapper = $('<div>').append($deleteBtn);
    var $row = $('<div>', { class: 'd-flex align-items-start gap-2' })
        .append($inputWrapper)
        .append($btnWrapper);

    // --- Form element wrapper ---
    var $formElem = $('<div>', { class: 'form-elem' })
        .append($label)
        .append($row);

    // --- Bootstrap col wrapper ---
    var $col = $('<div>', { class: 'col-sm-6', 'data-nsid': nsId }).append($formElem);

    // --- Append to row ---
    $('.custom-fields-row').append($col);

    // --- Re-number for consistency ---
    nameservers_renumber();
}

// Delete the selected host entry
function nameservers_deleteaddress(btn) {
    var id = $(btn).attr('id').split('_')[1]; // "ns_2_nameserverdelete" → "2"
    var selector = '[data-nsid="ns_' + id + '"]';
    $(selector).remove();

    // Re-number everything after removal
    nameservers_renumber();
}

// Re-number labels and IDs so that nameservers are sequential
function nameservers_renumber() {
    var count = 1;
    $('.custom-fields-row .col-sm-6').each(function () {
        var $col = $(this);
        var $input = $col.find('input.nameserver');
        var $label = $col.find('label.form-label');
        var $deleteBtn = $col.find('button.btn-outline-danger');

        // Only renumber name server fields, skip anything else (e.g. "Use Defaults")
        if ($input.length && $input.attr('id').startsWith('ns_')) {
            var nsId = 'ns_' + count;
            $col.attr('data-nsid', nsId);
            $label.attr('for', nsId).text('Name Server ' + count);
            $input.attr({ id: nsId, name: nsId });
            $deleteBtn.attr('id', nsId + '_nameserverdelete');
            count++;
        }
    });
}
